/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.workflow;

import java.util.Map;

import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.odf.ProgramItem;
import org.ametys.plugins.workflow.EnhancedCondition;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;

/**
 * OSWorkflow condition to check if odf content is publishable
 */
public class PublishableODFContentCondition extends AbstractContentWorkflowComponent implements EnhancedCondition
{
    @Override
    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException
    {
        return !(getContent(transientVars) instanceof ProgramItem programItem) || programItem.isPublishable();
    }

    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.odf", "PLUGINS_ODF_PUBLISHABLE_CONDITION_LABEL");
    }
}
