<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:fo="http://www.w3.org/1999/XSL/Format"
                              xmlns:cms="http://ametys.org/cms/3.0" 
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="cms">
    
    <xsl:import href="plugin:core://stylesheets/helper/text.xsl"/>
    
	<xsl:template name="common-content-richtext2pdf-field">
		<xsl:param name="value"/>
		<xsl:param name="title"/>
		<xsl:param name="level"/>
		
		<xsl:if test="cms:isNotRichTextEmpty($value)">
            <xsl:if test="normalize-space($title) != ''">
    			<fo:block>
    	            <xsl:call-template name="title-style">
    	            	<xsl:with-param name="level" select="$level"/>
    	            </xsl:call-template>
    	            <i18n:text>
    	                <xsl:attribute name="i18n:catalogue"><xsl:value-of select="substring-before($title,':')" /></xsl:attribute>
    	                <xsl:attribute name="i18n:key"><xsl:value-of select="substring-after($title,':')" /></xsl:attribute>                    
    	            </i18n:text>   
    	        </fo:block>
	        </xsl:if>
            
	        <fo:block>
	             <xsl:apply-templates select="$value/docbook:article">
					<xsl:with-param name="level" select="$level + 1"/>
				</xsl:apply-templates>
	        </fo:block>
		</xsl:if>
	</xsl:template>
	
    <xsl:template name="common-content2pdf-right-block">
    	<xsl:param name="label"/>
        <xsl:param name="value"/>
        
    	<xsl:if test="normalize-space($value) != ''">
            <fo:block>
            	<xsl:call-template name="para-style"/>
            	
                <xsl:if test="normalize-space($label) != ''">
            	   <fo:inline font-weight="bold">
                		 <i18n:text>
    	                    <xsl:attribute name="i18n:catalogue"><xsl:value-of select="substring-before($label,':')" /></xsl:attribute>
    	                    <xsl:attribute name="i18n:key"><xsl:value-of select="substring-after($label,':')" /></xsl:attribute>                    
    	                </i18n:text>
    	                <xsl:text> : </xsl:text>
    	            </fo:inline>
                </xsl:if>
                <xsl:value-of select="$value"/>
            </fo:block>
        </xsl:if>
    </xsl:template>  
    
    <xsl:template name="common-boolean2pdf-right-block">
    	<xsl:param name="label"/>
        <xsl:param name="value"/>
        
    	<xsl:if test="normalize-space($value) != ''">
            <fo:block>
            	<xsl:call-template name="para-style"/>
            	
                <xsl:if test="normalize-space($label) != ''">
                    <fo:inline font-weight="bold">
                        <i18n:text>
    	                    <xsl:attribute name="i18n:catalogue"><xsl:value-of select="substring-before($label,':')" /></xsl:attribute>
    	                    <xsl:attribute name="i18n:key"><xsl:value-of select="substring-after($label,':')" /></xsl:attribute>                    
    	                </i18n:text>
    	                <xsl:text> : </xsl:text>
                    </fo:inline>
                </xsl:if>
               	<xsl:choose>
                	<xsl:when test="$value = 'true'"><i18n:text i18n:key="PLUGINS_ODF_PROGRAM_YES" i18n:catalogue="plugin.odf"/></xsl:when>
                    <xsl:otherwise><i18n:text i18n:key="PLUGINS_ODF_PROGRAM_NO" i18n:catalogue="plugin.odf"/></xsl:otherwise>
               	</xsl:choose>
            </fo:block>
        </xsl:if>
    </xsl:template>  
    
</xsl:stylesheet>
