<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:cms="http://ametys.org/cms/3.0" 
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="cms">

	<xsl:import href="odfperson.xsl"/>
	
    <!-- Used in common.xsl -->
    <xsl:variable name="common-content-css-class-name">person odfperson view-abstract</xsl:variable>
    
    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl --> 
    <xsl:template name="common-content-body-content">
        <xsl:call-template name="person-role"/>
        
        <xsl:call-template name="person-infos"/>
        
        <xsl:call-template name="person-mail"/>
    </xsl:template>   
    
    <xsl:template name="person-infos">
        <xsl:if test="normalize-space(metadata/address) != '' or normalize-space(metadata/additionalAddress) != '' or normalize-space(metadata/zipCode) != '' or normalize-space(metadata/town) != '' or normalize-space(metadata/phone) != '' or normalize-space(metadata/fax) != ''">
            <p class="address">
                <xsl:if test="normalize-space(metadata/address) != ''"><xsl:value-of select="metadata/address"/><br/></xsl:if>
                <xsl:if test="normalize-space(metadata/additionalAddress) != ''"><xsl:value-of select="metadata/additionalAddress"/><br/></xsl:if>
                <xsl:if test="normalize-space(metadata/zipCode) != ''"><xsl:value-of select="metadata/zipCode"/><xsl:text> </xsl:text></xsl:if>
                <xsl:if test="normalize-space(metadata/town) != ''"><xsl:value-of select="metadata/town"/></xsl:if>
                
                <xsl:if test="normalize-space(metadata/phone) != ''">
                 	<br/><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_ODFPERSON_MOBILE"/><xsl:text> </xsl:text><xsl:value-of select="metadata/phone"/>
        		</xsl:if>
        		<xsl:if test="normalize-space(metadata/fax) != ''">
                 	<br/><i18n:text i18n:catalogue="plugin.odf" i18n:key="CONTENT_ODFPERSON_FAX"/><xsl:text> </xsl:text><xsl:value-of select="metadata/fax"/>
        		</xsl:if>
            </p>
        </xsl:if>         
    </xsl:template>      
	
</xsl:stylesheet>