/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool is a tool that display a tree of the ODF with other columns.
 * It does bring edition, hardcoded indicators
 * It removes DnD, the current selection message on bus
 */
Ext.define('Ametys.plugins.odf.tree.AbstractODFTreeGridTool', {
    extend: "Ametys.plugins.odf.tree.AbstractODFTreeTool",

    constructor: function(config)
    {
        config.checkValidationAtStartup = false;
        config.enableValidationCheck = false;
        
        this.callParent(arguments);
    },
    
    _getViewPlugins: function()
    {
        // overriden to deactivate drag'N'drop
        return [];
    },

    _getRootNodeInfo: function()
    {
        return Ext.apply(this.callParent(arguments), {
            allowDrag: false,
            allowDrop: false
        });
    },
    
    _getPathInTree: function(contentId, rootId, callback, scope)
    {
        if (contentId.match("^orgunitContent:") || rootId.match("^orgunitContent:"))
        {
            // OrgUnit are always at the root of trees, if we are here we can consider that the given orgunit is not part of our tree
            this.callParent(arguments);
        }
        else if (rootId.startsWith("programContent:"))
        {
            Ametys.data.ServerComm.callMethod({
                role: "org.ametys.odf.ODFHelper",
                methodName: "getPathInProgram", // <---------
                parameters: [contentId, rootId],
                callback: {
                    handler: callback,
                    scope: scope || this
                    },
                    errorMessage: true,
                    waitMessage: false
                });
        }
        else if (rootId.startsWith("courseContent:"))
        {
            Ametys.data.ServerComm.callMethod({
                role: "org.ametys.odf.ODFHelper",
                methodName: "getPathInCourse", // <---------
                parameters: [contentId, rootId],
                callback: {
                    handler: callback,
                    scope: scope || this
                    },
                    errorMessage: true,
                    waitMessage: false
                });
        }
        else
        {
            // Other rootId supported types... are not supported
            console.error("In the tool " + this.getId() + " the current selection " + contentId + " cannot be represented on a tree of root " + rootId);
            this.callParent(arguments);
        }
    },
    
    _getTreeConfig: function()
    {
        var treeCfg = this.callParent(arguments);
        treeCfg.listeners['dirtychange'] = {
            fn: this.onDirtyChange,
            scope: this
        };
        return treeCfg;
    },
    
    /**
     * @protected
     * When the store gets dirty or not dirty
     */
    onDirtyChange: function(dirty)
    {
        this.setDirty(dirty);
    }
});
