/*
 *  Copyright 2026 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/* Components */
const ContentWorkflowHelper = Ametys.serviceManager.lookup(org.ametys.cms.workflow.ContentWorkflowHelper.ROLE);

/* Initialize */
let courseParts = Repository.query("//element(*, ametys:coursePartContent)[@ametys-internal:currentStepId = 1]");
let total = courseParts.getSize();
let handled = 0;
let modified = 0;

/* Process */
courseParts.forEach(
    coursePart =>
    {
        let courseHolder = coursePart.getCourseHolder();
        
        if (courseHolder != null && courseHolder.getCourseParts().contains(coursePart) && courseHolder.getCurrentStepId() != 1)
        {
            if (courseHolder.isLocked())
            {
                courseHolder.unlock();
            }
            
            Content.doWorkflowAction(courseHolder, 22, { "comment": "Remise à l'état brouillon la cohérence des données" });
            modified++;
        }
        
        handled++;
        if (handled % 500 == 0)
        {
            logger.info(`${handled}/${total}`);
        }
    }
);

logger.info(`${modified}/${total} course parts has been updated`);