<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

	<xsl:import href="odfperson.xsl"/>
	
	<xsl:variable name="common-content-css-class-name">person odfperson view-main</xsl:variable>   

    <xsl:template name="common-content-body-content">
        <xsl:variable name="raw-is-title-visible">
            <xsl:call-template name="common-content-body-title-content">
            	<xsl:with-param name="title">
                    <xsl:if test="metadata/personTitle != ''">
                        <xsl:value-of select="metadata/personTitle"/><xsl:text> </xsl:text>
                    </xsl:if>
                    <xsl:value-of select="concat(metadata/lastName, ' ', metadata/givenName)"/>
                </xsl:with-param>
            	<xsl:with-param name="subtitle" select="metadata/role"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="truelevel">
            <xsl:choose>
                <xsl:when test="string-length($raw-is-title-visible) &gt; 0">2</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <div class="col-content">
        	<xsl:call-template name="person-role"/>
        
	        <xsl:call-template name="person-mail"/>
	
	        <xsl:call-template name="person-website"/>
	        
	        <xsl:call-template name="person-infos">
	            <xsl:with-param name="truelevel" select="$truelevel"/>
	        </xsl:call-template>
        </div>         
        <div class="col-right">
            <xsl:call-template name="right-content">
                <xsl:with-param name="truelevel" select="$truelevel"/>            
            </xsl:call-template>
        </div>  
        <div class="col-end"/>  
    </xsl:template> 
    
    <xsl:template name="right-content">
    	<xsl:param name="truelevel"/>
    	
    	<div class="bloc more-info">
        	 <xsl:element name="h{$truelevel}"><i18n:text i18n:key="CONTENT_ODFPERSON_CONTACT_INFO" i18n:catalogue="plugin.odf"/></xsl:element>
                
        	<xsl:call-template name="person-address"/> 
        	<xsl:call-template name="person-mobile"/>
	        <xsl:call-template name="person-fax"/>                     
        </div>
    </xsl:template>
	
</xsl:stylesheet>