/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


removeReferences("DUT");
removeReferences("Classe_Prepa");

function removeReferences(referenceToRemove)
{
    let count = 0;
    Repository.query(`//element(*, ametys:content)[@ametys-internal:contentType = 'odf-enumeration.Degree' and @ametys:certificationLabel = '${referenceToRemove}']`).forEach(
        content =>
        {
            Content.migrate( 
                content, 
                [_removeCertificationLabel], 
                true, /* old version still comptatible */ 
                null, /* no tag */ 
                false, /* verbose */
                true /* synchronize live */
            );
            count++;
        }
    );
    logger.info(`${count} has been updated to remove reference to certification label '${referenceToRemove}'`);
}

function _removeCertificationLabel(content)
{
    content.removeValue("certificationLabel");
}
