/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool displays the dashboard with changed values
 * @private
 */
 Ext.define('Ametys.plugins.odf.dashboard.DashboardWithChangesTool', {
    extend: 'Ametys.plugins.odf.dashboard.DashboardTool',
    
    _getRecentDraftColumnsConfig: function(taskNode)
    {
        var additionalColumns = [];
        if (Ext.dom.Query.selectValue('@showChanges', taskNode, 'false') == 'true')
        {
            additionalColumns.push({stateId: 'grid-column-attribute-changes', header: "{{i18n PLUGINS_ODF_DASHBOARD_COLUMN_ATTRIBUTE_CHANGES}}", width: 300, sortable: false, dataIndex: 'attribute-changes', renderer: this._renderAttributeChanges});
        }
        
        if (Ext.dom.Query.selectValue('@showImportantChanges', taskNode, 'false') == 'true')
        {
            additionalColumns.push({stateId: 'grid-column-important-attribute-changes', header: "{{i18n PLUGINS_ODF_DASHBOARD_COLUMN_IMPORTANT_ATTRIBUTE_CHANGES}}", width: 300, sortable: false, dataIndex: 'important-attribute-changes', renderer: this._renderAttributeChanges});
        }
        
        return Ext.Array.merge(this.callParent(arguments), additionalColumns);
    },
    
    _getTaskColumnsConfig: function(taskNode)
    {
        var additionalColumns = [];
        if (Ext.dom.Query.selectValue('@showChanges', taskNode, 'false') == 'true')
        {
            additionalColumns.push({stateId: 'grid-column-attribute-changes', header: "{{i18n PLUGINS_ODF_DASHBOARD_COLUMN_ATTRIBUTE_CHANGES}}", width: 300, sortable: false, dataIndex: 'attribute-changes', renderer: this._renderAttributeChanges});
        }
        
        if (Ext.dom.Query.selectValue('@showImportantChanges', taskNode, 'false') == 'true')
        {
            additionalColumns.push({stateId: 'grid-column-important-attribute-changes', header: "{{i18n PLUGINS_ODF_DASHBOARD_COLUMN_IMPORTANT_ATTRIBUTE_CHANGES}}", width: 300, sortable: false, dataIndex: 'important-attribute-changes', renderer: this._renderAttributeChanges});
        }
        
        return Ext.Array.merge(this.callParent(arguments), additionalColumns);
    },
    
    /**
     * Renders attribute changes.
     * @param {Object[]} value The changes, as JSON
     * @param {Boolean} value.isImportant 'true' if the change is important
     * @param {Object} value.modelItem The JSON representation of the model item holding the change
     * @param {String} value.modelItem.label The label of the model item holding the change
     * @return {String} The attribute changes to render.
     * @private
     */
    _renderAttributeChanges: function(value)
    {
        return value
                .map(function(v) { return v.modelItem.label; })
                .join('<br/>');
    }
 });
 
 