/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.cdmfr;

/**
 * Constants for CDM-fr tags, attributes and types.
 */
public interface CDMFRTagsConstants
{
    /** Namespace CDM-fr Ext. */
    public static final String NAMESPACE_CDMFR = "cdmfr:";
    
    /** Namespace CDM-fr Ametys extension. */
    public static final String NAMESPACE_AMETYS_CDM = "ametys-cdm:";
    
    /** Root tag. */
    public static final String TAG_CDM = "CDM";

    /** Organisational unit tag. */
    public static final String TAG_ORG_UNIT = "orgUnit";

    /** Org unit name. */
    public static final String TAG_ORG_UNIT_NAME = "orgUnitName";

    /** Org unit student facilities. */
    public static final String TAG_STUDENT_FACILITIES = "studentFacilities";

    /** Program tag. */
    public static final String TAG_PROGRAM = "program";

    /** Program ID tag. */
    public static final String TAG_PROGRAM_ID = "programID";

    /** Program name tag. */
    public static final String TAG_PROGRAM_NAME = "programName";
    
    /** Program ordinary name tag. */
    public static final String TAG_ORDINARY_NAME = "OrdinaryName";

    /** Program code tag. */
    public static final String TAG_PROGRAM_CODE = "programCode";

    /** Program description tag. */
    public static final String TAG_PROGRAM_DESCRIPTION = "programDescription";

    /** Web link tag. */
    public static final String TAG_WEB_LINK = "webLink";

    /** Href tag. */
    public static final String TAG_HREF = "href";

    /** Link name tag. */
    public static final String TAG_LINK_NAME = "linkName";

    /** Program structure tag. */
    public static final String TAG_PROGRAM_STRUCTURE = "programStructure";

    /** Qualification tag. */
    public static final String TAG_QUALIFICATION = "qualification";

    /** Statistics tag. */
    public static final String TAG_STATISTICS = "statistics";

    /** Learning objectives tag. */
    public static final String TAG_LEARNING_OBJECTIVES = "learningObjectives";

    /** Admission info tag. */
    public static final String TAG_ADMISSION_INFO = "admissionInfo";

    /** Admission description tag. */
    public static final String TAG_ADMISSION_DESCRIPTION = "admissionDescription";

    /** Student places tag. */
    public static final String TAG_STUDENT_PLACES = "studentPlaces";

    /** Teaching start tag. */
    public static final String TAG_TEACHING_START = "teachingStart";
    
    /** Teaching end tag. */
    public static final String TAG_TEACHING_END = "teachingEnd";

    /** Registration deadline tag. */
    public static final String TAG_REGISTRATION_DEADLINE = "registrationDeadline";
    
    /** Cancel deadline tag. */
    public static final String TAG_CANCEL_DEADLINE = "cancelDeadline";

    /** Registration detail tag. */
    public static final String TAG_REGISTRATION_DETAIL = "registrationDetail";
    
    /** Registration process tag. */
    public static final String TAG_REGISTRATION_PROCESS = "registrationProcess";

    /** Registration process modalities tag. */
    public static final String TAG_REGISTRATION_MODALITIES = "registrationModalities";
    
    /** Registration start tag. */
    public static final String TAG_REGISTRATION_START = "registrationStart";
    
    /** Level tag. */
    public static final String TAG_LEVEL = "level";
    
    /** Level tag. */
    public static final String TAG_LEVEL_CODE = "levelCode";

    /** Qualification name tag. */
    public static final String TAG_QUALIFICATION_NAME = "qualificationName";

    /** Student status tag. */
    public static final String TAG_STUDENT_STATUS = "studentStatus";
    
    /** ECTS required tag. */
    public static final String TAG_ECTS_REQUIRED = "ectsRequired";
    
    /** Degree tag. */
    public static final String TAG_DEGREE = "degree";

    /** Degree name tag. */
    public static final String TAG_DEGREE_NAME = "degreeName";

    /** Teaching place tag. */
    public static final String TAG_TEACHING_PLACE = "teachingPlace";

    /** Program reference tag. */
    public static final String TAG_REF_PROGRAM = "refProgram";

    /** Info block tag. */
    public static final String TAG_INFO_BLOCK = "infoBlock";

    /** Sub-block tag. */
    public static final String TAG_SUB_BLOCK = "subBlock";

    /** altLangBlock tag. */
    public static final String TAG_ALT_LANG_BLOCK = "altLangBlock";

    /** extension tag. */
    public static final String TAG_EXTENSION_BLOCK = "extension";

    /** Text tag. */
    public static final String TAG_TEXT = "text";

    /** Header tag. */
    public static final String TAG_HEADER = "header";

    /** Regulations tag. */
    public static final String TAG_REGULATIONS = "regulations";

    /** Expenses tag. */
    public static final String TAG_EXPENSES = "expenses";

    /** Recommanded prerequisites tag. */
    public static final String TAG_RECOMMANDED_PREREQUISITES = "recommendedPrerequisites";

    /** Formal prerequisites tag. */
    public static final String TAG_FORMAL_PREREQUISITES = "formalPrerequisites";

    /** Target group tag. */
    public static final String TAG_TARGET_GROUP = "targetGroup";

    /** Form of teaching tag. */
    public static final String TAG_FORM_OF_TEACHING = "formOfTeaching";

    /** Program duration tag. */
    public static final String TAG_PROGRAM_DURATION = "programDuration";

    /** Study abroad tag. */
    public static final String TAG_STUDY_ABROAD = "studyAbroad";

    /** Universal adjustment tag. */
    public static final String TAG_UNIVERSAL_ADJUSTMENT = "universalAdjustment";

    /** Qualification description tag. */
    public static final String TAG_QUALIFICATION_DESCRIPTION = "qualificationDescription";

    /** Credits tag. */
    public static final String TAG_CREDITS = "credits";
    
    /** Global volume tag. */
    public static final String TAG_GLOBAL_VOLUME = "globalVolume";

    /** Profession tag. */
    public static final String TAG_PROFESSION = "profession";

    /** Rome data tag. */
    public static final String TAG_ROME_DATA = "romeData";

    /** Study qualification tag. */
    public static final String TAG_STUDY_QUALIFICATION = "studyQualification";
    
    /** Competence description tag. */
    public static final String TAG_COMPETENCE_DESC = "competenceDesc";
    
    /** Competence validity tag. */
    public static final String TAG_COMPETENCE_VALIDITY = "competenceValidity";
    
    /** Sub program tag. */
    public static final String TAG_SUB_PROGRAM = "subProgram";

    /** Search word tag. */
    public static final String TAG_SEARCH_WORD = "searchword";

    /** Teaching term tag. */
    public static final String TAG_TEACHING_TERM = "teachingTerm";

    /** Course tag. */
    public static final String TAG_COURSE = "course";

    /** Course name tag. */
    public static final String TAG_COURSE_NAME = "courseName";

    /** Course ID tag. */
    public static final String TAG_COURSE_ID = "courseID";

    /** Course code tag. */
    public static final String TAG_COURSE_CODE = "courseCode";

    /** Course description tag. */
    public static final String TAG_COURSE_DESCRIPTION = "courseDescription";
    
    /** Contents of a course tag. */
    public static final String TAG_COURSE_CONTENTS = "courseContentsEC";

    /** Contacts tag. */
    public static final String TAG_CONTACTS = "contacts";

    /** Contact data tag. */
    public static final String TAG_CONTACT_DATA = "contactData";

    /** Contact name tag. */
    public static final String TAG_CONTACT_NAME = "contactName";

    /** Address tag. */
    public static final String TAG_ADDRESS = "adr";

    /** POBox tag. */
    public static final String TAG_POBOX = "pobox";

    /** Extadr tag. */
    public static final String TAG_EXTADR = "extadr";

    /** Region tag. */
    public static final String TAG_REGION = "region";

    /** Pcode tag. */
    public static final String TAG_PCODE = "pcode";

    /** Country tag. */
    public static final String TAG_COUNTRY = "country";

    /** Street tag. */
    public static final String TAG_STREET = "street";

    /** Locality tag. */
    public static final String TAG_LOCALITY = "locality";

    /** Phone tag. */
    public static final String TAG_PHONE = "telephone";

    /** Fax tag. */
    public static final String TAG_FAX = "fax";

    /** Email tag. */
    public static final String TAG_EMAIL = "email";

    /** RefCourse tag. */
    public static final String TAG_REF_COURSE = "refCourse";

    /** Criteria tag. */
    public static final String TAG_CRITERIA = "criteria";

    /** Criteria tag. */
    public static final String TAG_STUDY_FIELD = "studyField";

    /** Criteria tag. */
    public static final String TAG_PROFESSIONAL_DIPLOMA = "professionalDiploma";

    /** Criteria tag. */
    public static final String TAG_PLACE = "place";

    /** Criteria tag. */
    public static final String TAG_DIPLOMA = "diploma";

    /** Form of assessment tag. */
    public static final String TAG_FORM_OF_ASSESSMENT = "formOfAssessment";

    /** Instruction language tag. */
    public static final String TAG_INSTRUCTION_LANGUAGE = "instructionLanguage";

    /** Overlap tag. */
    public static final String TAG_OVERLAP = "overlap";

    /** Syllabus tag. */
    public static final String TAG_SYLLABUS = "syllabus";
    
    /** Bibliography tag. */
    public static final String TAG_BIBLIOGRAPHY = "bibliography";

    /** Exam tag. */
    public static final String TAG_EXAM = "exam";

    /** Exam name tag. */
    public static final String TAG_EXAM_NAME = "examName";

    /** Exam kind tag. */
    public static final String TAG_EXAM_KIND = "examKind";

    /** Evaluation deadline tag. */
    public static final String TAG_EVALUATION_DEADLINE = "evaluationDeadline";

    /** Exam start tag. */
    public static final String TAG_EXAM_START = "examStart";

    /** Exam end tag. */
    public static final String TAG_EXAM_END = "examEnd";

    /** Exam duration tag. */
    public static final String TAG_EXAM_DURATION = "examDuration";

    /** Exam location tag. */
    public static final String TAG_EXAM_LOCATION = "examLocation";

    /** Exam structure tag. */
    public static final String TAG_EXAM_STRUCTURE = "examStructure";

    /** Part structure tag. */
    public static final String TAG_PART_STRUCTURE = "partStructure";

    /** Exam parts tag. */
    public static final String TAG_EXAM_PARTS = "examParts";

    /** Teaching activity tag. */
    public static final String TAG_TEACHING_ACTIVITY = "teachingActivity";

    /** Teaching activity id tag. */
    public static final String TAG_TEACHING_ACTIVITY_ID = "teachingActivityID";

    /** Teaching activity name tag. */
    public static final String TAG_TEACHING_ACTIVITY_NAME = "teachingActivityName";

    /** Teaching activity structure tag. */
    public static final String TAG_TEACHING_ACTIVITY_STRUCTURE = "teachingActivityStructure";

    /** Timetable Element tag. */
    public static final String TAG_TIMETABLE_ELEMENT = "timetableElement";

    /** Reoccurring events tag. */
    public static final String TAG_REOCCURRING_EVENTS = "reoccurringEvents";

    /** Single event tag. */
    public static final String TAG_SINGLE_EVENT = "singleEvent";

    /** Occurrence rule tag. */
    public static final String TAG_OCCURRENCE_RULE = "occurrenceRule";

    /** Date from tag. */
    public static final String TAG_DATE_FROM = "dateFrom";

    /** Date to tag. */
    public static final String TAG_DATE_TO = "dateTo";

    /** Time from tag. */
    public static final String TAG_TIME_FROM = "timeFrom";

    /** Time to tag. */
    public static final String TAG_TIME_TO = "timeTo";

    /** Time of day tag. */
    public static final String TAG_TIME_OF_DAY = "timeOfDay";

    /** Start tag. */
    public static final String TAG_START = "start";

    /** End tag. */
    public static final String TAG_END = "end";

    /** Activity parts tag. */
    public static final String TAG_ACTIVITY_PARTS = "activityParts";

    /** Person reference tag. */
    public static final String TAG_REF_PERSON = "refPerson";

    /** Organisational unit reference tag. */
    public static final String TAG_REF_ORG_UNIT = "refOrgUnit";

    /** Person tag. */
    public static final String TAG_PERSON = "person";

    /** Person id tag. */
    public static final String TAG_PERSON_ID = "personID";

    /** Name tag. */
    public static final String TAG_NAME = "name";

    /** Given name tag. */
    public static final String TAG_GIVEN_NAME = "given";

    /** Family name tag. */
    public static final String TAG_FAMILY_NAME = "family";

    /** Title tag. */
    public static final String TAG_TITLE = "title";

    /** Role tag. */
    public static final String TAG_ROLE = "role";

    /** Affiliation tag. */
    public static final String TAG_AFFILIATION = "affiliation";
    
    /** Process field tag. */
    public static final String TAG_PROFESS_FIELD = "professField";
    
    /** Sect CNU tag. */
    public static final String TAG_SECT_CNU = "sectCNU";
    
    /** Org unit code tag. */
    public static final String TAG_ORG_UNIT_CODE = "orgUnitCode";

    /** Org unit id tag. */
    public static final String TAG_ORG_UNIT_ID = "orgUnitID";

    /** Org unit acronym tag. */
    public static final String TAG_ORG_UNIT_ACRONYM = "orgUnitAcronym";

    /** Org unit kind tag. */
    public static final String TAG_ORG_UNIT_KIND = "orgUnitKind";

    /** Org unit description tag. */
    public static final String TAG_ORG_UNIT_DESCRIPTION = "orgUnitDescription";
    
    /** Principal Instruction Language tag. */
    public static final String TAG_PPAL_TEACHING_LANGUAGE = "ppalTeachingLanguage";

    /** Habilitation tag. */
    public static final String TAG_HABILITATION = "habilitation";

    /** Habilitation ID tag. */
    public static final String TAG_HABILITATION_ID = "habiliId";
    
    /** Digital use tag. */
    public static final String TAG_DIGITAL_USE = "digitalUse";
    
    /** Percentage tag. */
    public static final String TAG_PERCENTAGE = "percentage";
    
    /** LCMS tag. */
    public static final String TAG_LCMS = "lcms";
    
    /** Exists tag. */
    public static final String TAG_EXISTS = "exists";
    
    /** Resource management tag. */
    public static final String TAG_RESOURCE_MGT = "resourceManagement";
    
    /** Percentage of use tag. */
    public static final String TAG_PERC_OF_USE = "percentageOfUse";
    
    /** Prod peda tag. */
    public static final String TAG_PROD_PEDA = "prodPeda";

    /** Digit prod percentage tag. */
    public static final String TAG_DIGIT_PROD_PERC = "digitProdPercentage";
    
    /** Digit prod UNT percentage tag. */
    public static final String TAG_DIGIT_PROD_UNT_PERC = "digitProdUNTPercentage";
    
    /** Org Type attribute. */
    public static final String ATTRIBUTE_ORG_TYPE = "orgType";

    /** Block lang attribute. */
    public static final String ATTRIBUTE_BLOCK_LANG = "blockLang";

    /** Date attribute. */
    public static final String ATTRIBUTE_DATE = "date";

    /** Time attribute. */
    public static final String ATTRIBUTE_TIME = "time";

    /** Room attribute. */
    public static final String ATTRIBUTE_ROOM = "room";

    /** Building attribute. */
    public static final String ATTRIBUTE_BUILDING = "building";

    /** Tel type attribute. */
    public static final String ATTRIBUTE_TEL_TYPE = "telType";

    /** ID attribute. */
    public static final String ATTRIBUTE_ID = "id";

    /** Diploma type attribute. */
    public static final String ATTRIBUTE_DIPLOMA_TYPE = "diplomaType";
    
    /** Ident attribute. */
    public static final String ATTRIBUTE_IDENT = "ident";

    /** Language attribute. */
    public static final String ATTRIBUTE_LANGUAGE = "language";

    /** Term attribute. */
    public static final String ATTRIBUTE_TERM = "term";

    /** Study pace attribute. */
    public static final String ATTRIBUTE_STUDY_PACE = "studyPace";

    /** Time of day attribute. */
    public static final String ATTRIBUTE_TIME_OF_DAY = "timeOfDay";

    /** ECTS credits attribute. */
    public static final String ATTRIBUTE_ECTS_CREDITS = "ECTScredits";

    /** Hours per week attribute. */
    public static final String ATTRIBUTE_HOURS_PER_WEEK = "hoursPerWeek";

    /** Total work load attribute. */
    public static final String ATTRIBUTE_TOTAL_WORK_LOAD = "totalWorkLoad";
    
    /** Teaching type : CM, TD, TP */
    public static final String ATTRIBUTE_TEACHING_TYPE = "teachingtype";
    
    /** Method attribute. */
    public static final String ATTRIBUTE_METHOD = "method";

    /** Org attribute. */
    public static final String ATTRIBUTE_ORG = "org";

    /** Price attribute. */
    public static final String ATTRIBUTE_PRICE = "price";

    /** Currency attribute. */
    public static final String ATTRIBUTE_CURRENCY = "currency";

    /** Level attribute. */
    public static final String ATTRIBUTE_LEVEL = "level";

    /** Equiv attribute. */
    public static final String ATTRIBUTE_EQUIV = "equiv";
    
    /** Competence yielding attribute. */
    public static final String ATTRIBUTE_COMPETENCE_YIELDING = "competenceYielding";

    /** County code attribute. */
    public static final String ATTRIBUTE_COUNTY_CODE = "countyCode";

    /** Places number attribute. */
    public static final String ATTRIBUTE_PLACES = "places";

    /** IdRef attribute. */
    public static final String ATTRIBUTE_ID_REF = "idRef";

    /** Ref attribute. */
    public static final String ATTRIBUTE_REF = "ref";

    /** Role attribute. */
    public static final String ATTRIBUTE_ROLE = "role";

    /** Activity part structure attribute. */
    public static final String ATTRIBUTE_ACTIVITY_PART_STRUCTURE = "activityPartStructure";

    /** CodeSet attribute. */
    public static final String ATTRIBUTE_CODE_SET = "codeSet";
    /** libSet attribute. */
    public static final String ATTRIBUTE_LIB_SET = "libSet";

    /** User defined attribute. */
    public static final String ATTRIBUTE_USER_DEFINED = "userDefined";

    /** Course Structure attribute. */
    public static final String ATTRIBUTE_COURSE_STRUCTURE = "courseStructure";

    /** Start attribute. */
    public static final String ATTRIBUTE_START = "start";

    /** Duration attribute. */
    public static final String ATTRIBUTE_DURATION = "duration";

    /** Degree attribute. */
    public static final String ATTRIBUTE_DEGREE = "degree";
    
    /** Degree attribute. */
    public static final String ATTRIBUTE_DEGREE_NOT_LMD = "degreeNotLMD";

    /** Teaching Language attribute. */
    public static final String ATTRIBUTE_TEACHING_LANG = "teachingLang";

    /** Teaching Start attribute. */
    public static final String ATTRIBUTE_TEACHING_START = "teachingStart";
    
    /** Limited attribute. */
    public static final String ATTRIBUTE_LIMITED = "limited";
    
    /** Nature attribute. */
    public static final String ATTRIBUTE_NATURE = "nature";
    
    /** Orgunit type attribute. */
    public static final String ATTRIBUTE_ORG_UNIT_KIND_CODE_VALUESET = "orgUnitKindCodeValueSet";
    
    /** CDMDateTime type. */
    public static final String TAG_CDM_DATE_TIME = "CDMDateTime";

    /** CDMLocation type. */
    public static final String TAG_CDM_LOCATION = "CDMLocation";

    /** Mobile phone type. */
    public static final String PHONE_TYPE_MOBILE = "mobile";

    /** Office phone type. */
    public static final String PHONE_TYPE_OFFICE = "office";

    /** Home phone type. */
    public static final String PHONE_TYPE_HOME = "home";

    // Specific values used for some attributes
    /** Degree value */
    public static final String VALUE_DIP = "DIP";

    /** Degree value for assisted search */
    public static final String VALUE_AS_DEGREE = "AS-DEGREE";

    /** Degree value */
    public static final String VALUE_DEGREE = "DEGREE";

    /** university value for orgType */
    public static final String VALUE_UNIVERSITY = "university";

    /** component value for orgType */
    public static final String VALUE_COMPONENT = "component";

    /** Course structure value : used in a courseDescription subBlock userDefined attribute. */
    public static final String VALUE_COURSE_STRUCTURE = "courseStructure";

    /** Habilitation value. */
    public static final String VALUE_DES = "DES";

    /** French language value. */
    public static final String VALUE_FR_FR = "fr-FR";

    /** ECUE value. */
    public static final String VALUE_EC = "EC";

    /** UE value. */
    public static final String VALUE_UE = "UE";

    /** value for userdefined UNRLR */
    public static final String VALUE_UNRLR = "UNRLR";

    /** value for userdefined SISE */
    public static final String VALUE_SISE = "disciplineSise";

    /** value for userdefined ERASMUS */
    public static final String VALUE_ERASMUS = "ERASMUS";

    /** value for userdefined RNCP */
    public static final String VALUE_RNCP = "RNCP";

    /** value for userdefined CITE97 */
    public static final String VALUE_CITE97 = "CITE97";

    /** value for userdefined complementaryInformations */
    public static final String VALUE_COMPLEMENTARY_INFORMATIONS = "complementaryInformations";

    /** value for userdefined associated schools */
    public static final String VALUE_ASSOCIATED_SCHOOLS = "etablissementsPartenaires";

    /** value for userdefined associated laboritories */
    public static final String VALUE_ASSOCIATED_LABORITORIES = "laboratoiresPartenaires";

    /** value for userdefined schoolpath */
    public static final String VALUE_SCHOOLPATH = "schoolPath";

    /** value for userdefined ueContainer */
    public static final String VALUE_UECONTAINER = "container";

    /** value for userdefined ueGroup */
    public static final String VALUE_UEGROUP = "ueGroup";

    /** value for userdefined Obligatoire */
    public static final String VALUE_OBLIGATOIRE = "Obligatoire";

    /** value for userdefined Facultative */
    public static final String VALUE_FACULTATIVE = "Facultative";

    /** value for userdefined A choix */
    public static final String VALUE_A_CHOIX = "A choix";

    /** value for userdefined subProgram type */
    public static final String VALUE_SUBPROG_TYPE = "subProgType";

    /** value for userdefined type */
    public static final String VALUE_TYPE = "type";

    /** value for userdefined nature */
    public static final String VALUE_EDUCATION_TYPE = "nature";

    /** Mention value. */
    public static final String VALUE_MENTION = "mention";

    /** value for userdefined area */
    public static final String VALUE_AREA = "area";

    /** Speciality value. */
    public static final String VALUE_SPECIALITY = "speciality";

    /** Presentation value. */
    public static final String VALUE_PRESENTATION = "presentation";

    /** Objectives value. */
    public static final String VALUE_OBJECTIVES = "objectives";

    /** Professional objectives value. */
    public static final String VALUE_PROFESSIONAL_OBJECTIVES = "professionalObjectives";

    /** Pursuing value. */
    public static final String VALUE_PURSUING = "pursuing";

    /** Knowledges value. */
    public static final String VALUE_KNOWLEDGES = "knowledges";

    /** Parent orgUnit. */
    public static final String VALUE_ORG_UNIT_PARENT = "orgUnitParent";

    /** Volume horaire. */
    public static final String VALUE_VOLUME_HORAIRE = "volumeHoraire";

    /** CM hours. */
    public static final String VALUE_VOLUME_HORAIRE_COURS = "volumeHoraireCours";

    /** TD hours. */
    public static final String VALUE_VOLUME_HORAIRE_TD = "volumeHoraireTD";

    /** TP hours. */
    public static final String VALUE_VOLUME_HORAIRE_TP = "volumeHoraireTP";

    /** Form of teaching org values */
    /** formInit */
    public static final String VALUE_INIT = "formInit";
    /** formCont */
    public static final String VALUE_CONTINUE = "formCont";
    /** formPro */
    public static final String VALUE_PRO = "formPro";
    /** formContNonDip */
    public static final String VALUE_FORMCONTNONDIP = "formContNonDip";
    /** formAppr */
    public static final String VALUE_APPRENTICESHIP = "formAppr";

    /** frenchLanguage education */
    public static final String VALUE_FRENCHLANGUAGE = "frenchLanguage";

    /** international education */
    public static final String VALUE_INTERNATIONAL = "international";

    /** en présence education */
    public static final String VALUE_PRESENCE = "en présence";
    
    /** distance education */
    public static final String VALUE_DISTANCE = "à distance";

    /** abroad internship */
    public static final String VALUE_INTERNSHIP = "internship";

    /** professionnal finality */
    public static final String VALUE_FINALITE = "finalite";

    /** professionnal value */
    public static final String VALUE_PROFESSIONAL = "professionnelle";

    /** downloading */
    public static final String VALUE_DOWNLOADING = "telechargement";

    /** knowMoreLink */
    public static final String VALUE_KNOWMORELINK = "enSavoirPlus";

    /** stage */
    public static final String VALUE_STAGE = "stage";

    /** duree */
    public static final String VALUE_DUREE = "durée";
}
