/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.content.code;

import java.util.Optional;

import org.ametys.cms.repository.Content;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.Supporter;

/**
 * Interface for a provider of a ODF content display code
 */
public interface DisplayCodeProvider extends Supporter<Content>
{
    /**
     * Retrieves the id of the content type.
     * @return the id.
     */
    String getId();
    
    /**
     * Get the label
     * @return The label
     */
    public I18nizableText getLabel();
    
    /**
     * Get the display code of this content
     * @param content the content
     * @return the display code
     */
    public Optional<String> getDisplayCode(Content content);
    
    /**
     * Determines if the provider is active
     * @return true if the provider is active
     */
    public default boolean isActive() 
    {
        return true;
    }
}
