/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.courselist;

import java.util.List;


/**
 * Interface representing a container of {@link CourseList}
 */
public interface CourseListContainer
{
    /**
     * Returns the child course lists
     * @return the child course lists
     */
    public List<CourseList> getCourseLists();
    
    /**
     * Determines if this {@link CourseListContainer} contains the given course list as child
     * @param clId id of the {@link CourseList} to test
     * @return true if the course list is part of this {@link CourseListContainer}
     */
    public boolean containsCourseList(String clId);
    
    /**
     * Determines if this {@link CourseListContainer} contains child course list
     * @return true if this {@link CourseListContainer} contains at least a child course list
     */
    public boolean hasCourseLists();
}
