/*
 *  Copyright 2012 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.odf.program;

import java.util.List;

import org.ametys.odf.ProgramItem;
import org.ametys.plugins.repository.data.ametysobject.ModifiableModelAwareDataAwareAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;

/**
 * Represents a part of a {@link Program}, be it the Program itself, a {@link SubProgram} or a {@link Container}.
 */
public interface ProgramPart extends ModifiableModelAwareDataAwareAmetysObject, JCRAmetysObject, ProgramItem
{
    /** Name of the attribute holding the direct parent */
    public static final String PARENT_PROGRAM_PARTS = "parentProgramParts";
    
    /**
     * Returns the direct parent {@link ProgramPart}s
     * @return the direct parent {@link ProgramPart}s in a List
     */
    public List<ProgramPart> getProgramPartParents();
}
