/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.generator;

import java.io.IOException;
import java.util.Map;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.context.PageSubscriptionContext;
import org.ametys.plugins.pagesubscription.type.PageSubscriptionType;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class UserPageSubscriptionsGenerator
extends ServiceableGenerator {
    protected CurrentUserProvider _currentUserProvider;
    protected SiteManager _siteManager;
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(this.manager);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)smanager.lookup(SubscriptionTypeExtensionPoint.ROLE));
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"subscriptions");
        FrequencyHelper.saxFrequencies(this.contentHandler);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String siteName = WebHelper.getSiteName((Request)request);
        PageSubscriptionType subscriptionType = (PageSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.page");
        Site site = this._siteManager.getSite(siteName);
        for (Subscription subscription : subscriptionType.getUserSubscriptions(site, this._currentUserProvider.getUser(), false, PageSubscriptionContext.newInstance())) {
            subscriptionType.saxSubscription(this.contentHandler, subscription);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"subscriptions");
        this.contentHandler.endDocument();
    }
}

