/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.observation;

import java.util.List;
import java.util.Map;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.context.PageSubscriptionContext;
import org.ametys.plugins.pagesubscription.type.PageSubscriptionType;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class RemoveSubscriptionOnPageDeletedObserver
extends AbstractLogEnabled
implements Observer,
Serviceable,
Contextualizable {
    protected AmetysObjectResolver _resolver;
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;
    protected Context _context;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)manager.lookup(SubscriptionTypeExtensionPoint.ROLE));
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public boolean supports(Event event) {
        return event.getId().equals("page.deleting");
    }

    public int getPriority(Event event) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            String pageId = (String)event.getArguments().get("page.id");
            PageSubscriptionType pageSubscriptionType = (PageSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.page");
            Page page = (Page)this._resolver.resolveById(pageId);
            PageSubscriptionContext context = PageSubscriptionContext.newInstance().withPage(page);
            List<Subscription> subscriptions = pageSubscriptionType.getSubscriptions(page.getSite(), null, null, context);
            for (Subscription subscription : subscriptions) {
                pageSubscriptionType.unsubscribe(subscription);
            }
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }
}

