/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.page;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.pagesubscription.page.PageSubscriptionDAO;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class InfoSubscriberGenerator
extends ServiceableGenerator {
    protected static final Pattern EMAIL_VALIDATOR = SendMailHelper.EMAIL_VALIDATION;
    protected static final Pattern TEXT_VALIDATOR = Pattern.compile("^\\s*$");
    protected AmetysObjectResolver _resolver;
    protected UserManager _foUserManager;
    protected CurrentUserProvider _currentUserProvider;
    protected PageSubscriptionDAO _subscriptionDAO;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._subscriptionDAO = (PageSubscriptionDAO)((Object)smanager.lookup(PageSubscriptionDAO.ROLE));
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._foUserManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        this.contentHandler.startDocument();
        AttributesImpl attr = new AttributesImpl();
        if (userIdentity == null) {
            attr.addCDATAAttribute("isLogged", "false");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"user", (Attributes)attr);
        } else {
            User user = this._foUserManager.getUser(userIdentity.getPopulationId(), userIdentity.getLogin());
            attr.addCDATAAttribute("isLogged", "true");
            String email = user.getEmail();
            String pageId = request.getParameter("page-id");
            if (pageId == null) {
                throw new IllegalArgumentException("Unable to subscribe or unsubscribe to the page: cannot determine the current page");
            }
            Page page = (Page)this._resolver.resolveById(pageId);
            boolean isSubscriber = this._subscriptionDAO.isSubscriber(page, email);
            attr.addCDATAAttribute("isRegistered", Boolean.toString(isSubscriber));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"user", (Attributes)attr, (String)email);
        }
        this.contentHandler.endDocument();
    }
}

