/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.schedulable.page;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.notification.PageNotificationsHelper;
import org.ametys.plugins.pagesubscription.type.PageSubscriptionType;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.mail.ReportActivitiesMailBodyHelper;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageDAO;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.quartz.JobExecutionContext;

public class SendPageNotificationSummarySchedulable
extends AbstractStaticSchedulable {
    public static final String FOLLOWED_PAGES_CONFIG_PAGE_TAG = "TAG_FOLLOWED_PAGES_CONFIG";
    protected FrequencyHelper.Frequency _frequency;
    protected I18nizableText _mailSubject;
    protected I18nizableText _mailTitle;
    protected I18nizableText _mailMessage;
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;
    protected PageSubscriptionType _pageSubscriptionType;
    protected SiteManager _siteManager;
    protected I18nUtils _i18nUtils;
    protected PageNotificationsHelper _pageNotificationHelper;
    protected AmetysObjectResolver _resolver;
    protected PageDAO _pageDAO;
    protected RenderingContextHandler _renderingContextHandler;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)manager.lookup(SubscriptionTypeExtensionPoint.ROLE));
        this._pageSubscriptionType = (PageSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.page");
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._pageNotificationHelper = (PageNotificationsHelper)((Object)manager.lookup(PageNotificationsHelper.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._pageDAO = (PageDAO)manager.lookup(PageDAO.ROLE);
        this._renderingContextHandler = (RenderingContextHandler)manager.lookup(RenderingContextHandler.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this._frequency = FrequencyHelper.Frequency.valueOf(configuration.getChild("frequency").getValue("DAILY"));
        this._mailSubject = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("mail-subject"), (String)("plugin." + this._pluginName));
        this._mailTitle = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("mail-title"), (String)("plugin." + this._pluginName));
        this._mailMessage = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("mail-message"), (String)("plugin." + this._pluginName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        for (Site site : this._siteManager.getSites()) {
            Request request = ContextHelper.getRequest((Context)this._context);
            RenderingContext currentContext = this._renderingContextHandler.getRenderingContext();
            try {
                this._renderingContextHandler.setRenderingContext(RenderingContext.FRONT);
                request.setAttribute("site", (Object)site.getName());
                Map<UserIdentity, Set<Activity>> pageActivitiesBySubscriber = this._getPageActivitiesBySubscriber(site);
                for (UserIdentity subscriber : pageActivitiesBySubscriber.keySet()) {
                    Set<Activity> pageActivities = pageActivitiesBySubscriber.get(subscriber);
                    if (pageActivities.isEmpty()) continue;
                    String lang = this._getLanguage(pageActivities);
                    String subject = this._i18nUtils.translate((I18nizable)this._getI18nSubject(site), lang);
                    String body = this._getMailBody(site, pageActivities, lang);
                    User user = this._userManager.getUser(subscriber);
                    if (user == null) continue;
                    SendMailHelper.newMail().withRecipient(user.getEmail()).withSubject(subject).withHTMLBody(body).withInlineCSS(false).withAsync(true).sendMail();
                }
            }
            finally {
                this._renderingContextHandler.setRenderingContext(currentContext);
            }
        }
    }

    private Map<UserIdentity, Set<Activity>> _getPageActivitiesBySubscriber(Site site) {
        HashMap<UserIdentity, Set<Activity>> pageActivitiesBySubscriber = new HashMap<UserIdentity, Set<Activity>>();
        for (Subscription subscription : this._pageSubscriptionType.getSubscriptions(site, this._frequency, BroadcastChannelHelper.BroadcastChannel.MAIL, null)) {
            UserIdentity subscriber = subscription.getSubscriber().get();
            Set pages = pageActivitiesBySubscriber.getOrDefault(subscriber, new HashSet());
            String pageId = this._pageSubscriptionType.getTarget(subscription);
            Activity lastActivity = this._pageNotificationHelper.getLastActivity(site.getName(), pageId, subscription.getFrequency());
            if (lastActivity != null) {
                pages.add(lastActivity);
            }
            pageActivitiesBySubscriber.put(subscriber, pages);
        }
        return pageActivitiesBySubscriber;
    }

    private String _getLanguage(Set<Activity> pageActivities) {
        return pageActivities.stream().map(a -> (String)a.getValue("pageId")).map(id -> (Page)this._resolver.resolveById(id)).filter(Objects::nonNull).map(SitemapElement::getSitemapName).findFirst().get();
    }

    protected I18nizableText _getI18nSubject(Site site) {
        Map<String, I18nizableText> params = Map.of("site", new I18nizableText(site.getTitle()));
        return new I18nizableText(this._mailSubject.getCatalogue(), this._mailSubject.getKey(), params);
    }

    protected String _getMailBody(Site site, Set<Activity> pages, String lang) throws IOException {
        List<ReportActivitiesMailBodyHelper.MailBodyBuilder.Activity> activities = pages.stream().map(a -> this._wrapActivity((Activity)a, lang)).toList();
        ReportActivitiesMailBodyHelper.MailBodyBuilder bodyBuilder = ReportActivitiesMailBodyHelper.newHTMLBody().withLanguage(lang).withTitle((Object)this._mailTitle).withMessage((Object)this._mailMessage).withActivities(activities).withLink(site.getUrl(), new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIPTION_MAIL_NOTIFICATIONS_MAIL_SITE_LINK"));
        Optional<String> pageTagUrl = this._pageDAO.findPagedIdsByTag(site.getName(), lang, FOLLOWED_PAGES_CONFIG_PAGE_TAG).stream().map(id -> ResolveURIComponent.resolve((String)"page", (String)id, (boolean)false, (boolean)true)).findFirst();
        if (pageTagUrl.isPresent()) {
            bodyBuilder.withFooterLink(pageTagUrl.get(), new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIPTION_MAIL_PAGE_NOTIFICATIONS_MAIL_PREFERENCE_LINK"), "core-ui", "img/mail/icon-letter.png");
        }
        return bodyBuilder.build();
    }

    private ReportActivitiesMailBodyHelper.MailBodyBuilder.Activity _wrapActivity(Activity activity, String lang) {
        HashMap<String, I18nizableText> parameters = new HashMap<String, I18nizableText>();
        parameters.put("pageTitle", new I18nizableText((String)activity.getValue("pageTitle")));
        String pageId = (String)activity.getValue("pageId");
        String pageUrl = ResolveURIComponent.resolve((String)"page", (String)pageId, (boolean)false, (boolean)true);
        parameters.put("pageUrl", new I18nizableText(pageUrl));
        I18nizableText messageI18n = new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIPTION_MAIL_PAGE_NOTIFICATIONS_MAIL_CONTENT_MESSAGE", parameters);
        String message = this._i18nUtils.translate((I18nizable)messageI18n, lang);
        return new ReportActivitiesMailBodyHelper.MailBodyBuilder.Activity(null, activity.getDate(), (Object)message);
    }
}

