<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:v="urn:schemas-microsoft-com:vml"
                              xmlns:o="urn:schemas-microsoft-com:office:office"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">
    
    <xsl:import href="view:web://stylesheets/mail/standard/template.xsl"/>
    
    <!-- Additional components -->
    <xsl:import href="components/contents.xsl"/>
    <xsl:import href="components/item-content.xsl"/>
    
    <!-- Additional styles -->
    <xsl:import href="components/styles.xsl"/>
    
    <xsl:variable name="date-format" select="ametys:translate('plugin.page-subscription:PLUGINS_PAGE_SUBSCRIPTION_MAIL_DATE_FORMAT')"></xsl:variable>

    <xsl:template name="content-inner">
        <!-- Title with tag -->
        <xsl:apply-templates select="title" mode="message"/>
        
        <!-- Date and frequency-->
        <xsl:call-template name="hint"/>
        
        <!-- Message -->
        <xsl:call-template name="messages"/>
        
        <!-- Contents -->
        <xsl:call-template name="contents"/>
        
        <!-- Button link -->
        <xsl:apply-templates select="link" mode="button"/>
        
    </xsl:template>
    
    <xsl:template name="hint">
        <xsl:param name="width">500</xsl:param>
        <xsl:param name="margin-top">5</xsl:param>
        <xsl:param name="margin-bottom">15</xsl:param>
        <xsl:param name="margin-left">0</xsl:param>
        <xsl:param name="margin-right">0</xsl:param>
        <xsl:param name="hint" select="hint"/>
        
        <xsl:call-template name="msoif-open">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
    
        <div style="max-width: {$width}px; margin: 0px auto">
            <table>
                <xsl:call-template name="table-layout-attributes" />
                <tbody>
                    <tr>
                        <td>
                            <xsl:call-template name="td-layout-attributes" />
                            <table>
                                <xsl:call-template name="table-layout-attributes" />
                                <tbody>
                                    <xsl:call-template name="row-vertical-spacer">
                                        <xsl:with-param name="height" select="$margin-top"/>
                                    </xsl:call-template>
                                    <tr>
                                        <td>
                                            <xsl:call-template name="td-layout-attributes" />
                                            <xsl:call-template name="hint-text">
                                                <xsl:with-param name="text" select="$hint"/>
                                            </xsl:call-template>
                                        </td>
                                    </tr>
                                    <xsl:call-template name="row-vertical-spacer">
                                        <xsl:with-param name="height" select="$margin-bottom"/>
                                    </xsl:call-template>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <xsl:call-template name="msoif-close" />
    </xsl:template>
    
    <xsl:template name="hint-text">
        <xsl:param name="imgPath">img/icon/mail/icon-abonnements.png</xsl:param>
        <xsl:param name="imgPluginName">page-subscription</xsl:param>
        <xsl:param name="text"/>
        
        <xsl:if test="$text">
            <table cellspacing="8">
              <xsl:call-template name="table-layout-attributes" />
              <tr>
                <xsl:if test="$imgPath">
                    <td width="24">
                        <img
                            src="{ametys:pluginImageBase64($imgPluginName, $imgPath)}"
                            alt=""
                            width="24" height="19" valign="middle"
                          />
                    </td>
                    <xsl:call-template name="row-horizontal-spacer">
                        <xsl:with-param name="width">10</xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
                <td>
                  <span>
                    <xsl:call-template name="hint-style"/>
                    <xsl:value-of select="$text" />
                  </span>
                </td>
              </tr>
            </table>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
