/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.pagesubscription;

/**
 * Common exception for all subscriptions.
 */
public class SubscriptionException extends RuntimeException
{
    private Type _type;
    
    /**
     * The type of the exception.
     */
    public enum Type
    {
        /** The subscription already exist */
        ALREADY_EXIST,
        /** An user different of the subscriber try to access to the subscription */
        NO_ACCESS,
        /** Unknown errors */
        UNKNOWN;
    }
    
    /**
     * Constructs a new SubscriptionException.
     */
    public SubscriptionException()
    {
        super();
        _type = Type.UNKNOWN;
    }
    
    /**
     * Constructs a new SubscriptionException with the specified message.
     * @param message the message of the exception.
     */
    public SubscriptionException(String message)
    {
        super(message);
        _type = Type.UNKNOWN;
    }
    
    /**
     * Constructs a new SubscriptionException with the specified message.
     * @param message the message of the exception.
     * @param type the type of the exception
     */
    public SubscriptionException(String message, Type type)
    {
        super(message);
        _type = type;
    }
    
    /**
     * Constructs a new SubscriptionException with the specified message and cause.
     * @param message the message of the exception.
     * @param cause the cause of the exception.
     */
    public SubscriptionException(String message, Throwable cause)
    {
        super(message, cause);
        _type = Type.UNKNOWN;
    }
    
    /**
     * Constructs a new SubscriptionException with the specified message and cause.
     * @param message the message of the exception.
     * @param cause the cause of the exception.
     * @param type the type of the exception
     */
    public SubscriptionException(String message, Throwable cause, Type type)
    {
        super(message, cause);
        _type = type;
    }
    
    /**
     * Constructs a new SubscriptionException with the specified cause.
     * @param cause the cause of the exception.
     */
    public SubscriptionException(Throwable cause)
    {
        super(cause);
        _type = Type.UNKNOWN;
    }
    
    /**
     * Constructs a new SubscriptionException with the specified cause.
     * @param cause the cause of the exception.
     * @param type the type of the exception
     */
    public SubscriptionException(Throwable cause, Type type)
    {
        super(cause);
        _type = type;
    }
    
    /**
     * Get the type of the exception
     * @return the type
     */
    public Type getType()
    {
        return _type;
    }
}
