/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.pagesubscription.context;

import org.ametys.plugins.pagesubscription.type.PageSubscriptionType;
import org.ametys.web.repository.page.Page;

/**
 * Class to represent a context for {@link PageSubscriptionType}
 */
public class PageSubscriptionContext extends SubscriptionContext
{
    /**  The page */
    protected Page _page;
    
    /**
     * Creates a new instance of a {@link PageSubscriptionContext}
     */
    protected PageSubscriptionContext()
    {
        super();
    }
    
    /**
     * Creates a new instance of a {@link PageSubscriptionContext}
     * @return the created instance
     */
    public static PageSubscriptionContext newInstance()
    {
        return new PageSubscriptionContext();
    }
    
    /**
     * Add a page to the context
     * @param page the pgae
     * @return the context
     */
    public PageSubscriptionContext withPage(Page page)
    {
        _page = page;
        return this;
    }

    /**
     * Get the page
     * @return the page
     */
    public Page getPage()
    {
        return _page;
    }
}
