/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.context.PageSubscriptionContext;
import org.ametys.plugins.pagesubscription.dao.AbstractSubscriptionsDAO;
import org.ametys.plugins.pagesubscription.type.PageSubscriptionType;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.tuple.Pair;

public class PageSubscriptionsDAO
extends AbstractSubscriptionsDAO {
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;
    protected PageSubscriptionType _pageSubscriptionType;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)smanager.lookup(SubscriptionTypeExtensionPoint.ROLE));
        this._pageSubscriptionType = (PageSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.page");
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.pageaccess")
    public Map<String, Object> getPageSubscriptions(String pageId) {
        UserIdentity user = this._currentUserProvider.getUser();
        Page page = (Page)this._resolver.resolveById(pageId);
        return this._getPageSubscriptions(page, user);
    }

    private Map<String, Object> _getPageSubscriptions(Page page, UserIdentity user) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Set<UserIdentity> subscribers = this.getPageSubscribers(page);
        results.put("hasSubscribed", subscribers.stream().filter(u -> u.equals((Object)user)).findAny().isPresent());
        results.put("nbSubscribers", subscribers.size());
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.pageaccess")
    public Map<String, Object> subscribePage(String pageId) {
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        HashMap<String, Object> results = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        Page page = (Page)this._resolver.resolveById(pageId);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            Pair<FrequencyHelper.Frequency, List<BroadcastChannelHelper.BroadcastChannel>> defaultPreference = this._getDefaultPreference(page.getSite());
            PageSubscriptionContext context = PageSubscriptionContext.newInstance().withPage(page);
            this._pageSubscriptionType.subscribe(page.getSite(), user, (FrequencyHelper.Frequency)((Object)defaultPreference.getLeft()), (List<BroadcastChannelHelper.BroadcastChannel>)((List)defaultPreference.getRight()), context);
            results.put("success", true);
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred subscribing to the page with id '{}'", (Object)pageId, (Object)e);
            results.put("success", false);
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
        results.putAll(this._getPageSubscriptions(page, user));
        return results;
    }

    private Pair<FrequencyHelper.Frequency, List<BroadcastChannelHelper.BroadcastChannel>> _getDefaultPreference(Site site) {
        String frequencyValue = (String)site.getValue("page-default-frequency", true, (Object)FrequencyHelper.Frequency.DAILY.name());
        return "NOMAIL".equals(frequencyValue) ? Pair.of((Object)((Object)FrequencyHelper.Frequency.INSTANT), List.of(BroadcastChannelHelper.BroadcastChannel.SITE)) : Pair.of((Object)((Object)FrequencyHelper.Frequency.valueOf(frequencyValue)), List.of(BroadcastChannelHelper.BroadcastChannel.MAIL, BroadcastChannelHelper.BroadcastChannel.SITE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.pageaccess")
    public Map<String, Object> unsubscribePage(String pageId) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        UserIdentity user = this._currentUserProvider.getUser();
        Page page = (Page)this._resolver.resolveById(pageId);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            PageSubscriptionContext context = PageSubscriptionContext.newInstance().withPage(page);
            this._pageSubscriptionType.unsubscribe(page.getSite(), user, context);
            results.put("success", true);
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred unsubscribing to the page with id '{}'", (Object)pageId, (Object)e);
            results.put("success", false);
            HashMap<String, Object> hashMap = results;
            return hashMap;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
        results.putAll(this._getPageSubscriptions(page, user));
        return results;
    }

    public Set<UserIdentity> getPageSubscribers(Page page) {
        PageSubscriptionContext context = PageSubscriptionContext.newInstance().withPage(page);
        return this._pageSubscriptionType.getSubscribers(page.getSite(), null, null, context);
    }
}

