/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.notification;

import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.cms.tag.TagProviderExtensionPoint;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.type.SubscriptionType;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.pagesubscription.type.TagSubscriptionType;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityHelper;
import org.ametys.plugins.repository.activities.ActivityTypeExtensionPoint;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.activities.PageUpdatedActivityType;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class TagNotificationsHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = TagNotificationsHelper.class.getName();
    protected AmetysObjectResolver _resolver;
    protected SiteManager _siteManager;
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;
    protected CurrentUserProvider _currentUserProvider;
    protected TagProviderExtensionPoint _tagProviderEP;
    protected AbstractCacheManager _cacheManager;
    protected ActivityTypeExtensionPoint _activityTypeEP;
    protected RightManager _rightManager;

    public void service(ServiceManager smanager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)smanager.lookup(SubscriptionTypeExtensionPoint.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._tagProviderEP = (TagProviderExtensionPoint)smanager.lookup(TagProviderExtensionPoint.ROLE);
        this._cacheManager = (AbstractCacheManager)smanager.lookup(AbstractCacheManager.ROLE);
        this._activityTypeEP = (ActivityTypeExtensionPoint)smanager.lookup(ActivityTypeExtensionPoint.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createMemoryCache(ROLE, new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_TAG_CACHE"), new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_TAG_CACHE_DESCRIPTION"), true, null);
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getUserContentNotifications(String siteName) {
        ArrayList<Map<String, Object>> notifications2json = new ArrayList<Map<String, Object>>();
        Site site = this._siteManager.getSite(siteName);
        UserIdentity user = this._currentUserProvider.getUser();
        TagSubscriptionType tagSubscriptionType = (TagSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.tag");
        List<Subscription> subscriptions = tagSubscriptionType.getUserSubscriptions(site, null, BroadcastChannelHelper.BroadcastChannel.SITE, user, false, null);
        for (Subscription subscription : subscriptions) {
            Map<String, Object> subscriptionAsJson = tagSubscriptionType.subscriptionToJSON(subscription);
            Map<Content, ZonedDateTime> contents = this.getUpdatedContents(subscription);
            if (!contents.isEmpty()) {
                List<Map> contentsAsJson = contents.keySet().stream().map(c -> Map.of("id", c.getId(), "title", c.getTitle())).toList();
                subscriptionAsJson.put("contents", contentsAsJson);
                ZonedDateTime lastActivityDate = subscription.getFrequency() != FrequencyHelper.Frequency.INSTANT ? this._getNotificationDate(subscription) : contents.values().stream().max(ChronoZonedDateTime::compareTo).get();
                subscriptionAsJson.put("lastActivityDate", lastActivityDate);
                ZonedDateTime lastReadDate = tagSubscriptionType.getLastReadDate(subscription, user);
                boolean hasRead = lastReadDate != null && lastReadDate.isAfter(lastActivityDate);
                subscriptionAsJson.put("hasRead", hasRead);
            }
            notifications2json.add(subscriptionAsJson);
        }
        return notifications2json;
    }

    public Map<Content, ZonedDateTime> getUpdatedContents(Subscription subscription) {
        String siteName = subscription.getSite().getName();
        String tagName = (String)subscription.getValue("tag");
        FrequencyHelper.Frequency frequency = subscription.getFrequency();
        ZonedDateTime notificationDate = this._getNotificationDate(subscription);
        TagSubscriptionKey key = TagSubscriptionKey.of(siteName, tagName, frequency, notificationDate);
        Map contents = (Map)this._getCache().get((Object)key, k -> this._getUpdatedContents(siteName, tagName, frequency, notificationDate));
        return contents.keySet().stream().map(this::_resolveSilently).filter(Objects::nonNull).filter(c -> this._rightManager.currentUserHasReadAccess(c)).collect(Collectors.toMap(c -> c, c -> (ZonedDateTime)contents.get(c.getId()), (e1, e2) -> e2, LinkedHashMap::new));
    }

    public Map<Content, ZonedDateTime> getUpdatedContents(String siteName, String tagName, FrequencyHelper.Frequency frequency, SubscriptionType.FrequencyTiming timing) {
        return this.getUpdatedContents(siteName, tagName, frequency, timing, this._currentUserProvider.getUser());
    }

    public Map<Content, ZonedDateTime> getUpdatedContents(String siteName, String tagName, FrequencyHelper.Frequency frequency, SubscriptionType.FrequencyTiming timing, UserIdentity user) {
        ZonedDateTime notificationDate = FrequencyHelper.getNotificationDate(frequency, timing);
        TagSubscriptionKey key = TagSubscriptionKey.of(siteName, tagName, frequency, notificationDate);
        Map contents = (Map)this._getCache().get((Object)key, k -> this._getUpdatedContents(siteName, tagName, frequency, notificationDate));
        return contents.keySet().stream().map(this::_resolveSilently).filter(Objects::nonNull).filter(c -> this._rightManager.hasReadAccess(user, c)).collect(Collectors.toMap(c -> c, c -> (ZonedDateTime)contents.get(c.getId()), (e1, e2) -> e2, LinkedHashMap::new));
    }

    private Map<String, ZonedDateTime> _getUpdatedContents(String siteName, String tagName, FrequencyHelper.Frequency frequency, ZonedDateTime notificationDate) {
        HashMap<String, ZonedDateTime> contents = new HashMap<String, ZonedDateTime>();
        for (Activity activity : this._getContentActivities(siteName, tagName, frequency, notificationDate)) {
            String contentId = (String)activity.getValue("contentId");
            Content content = this._resolveSilently(contentId);
            if (content == null) continue;
            ZonedDateTime date = (ZonedDateTime)activity.getValue("date");
            if (contents.containsKey(contentId)) {
                ZonedDateTime lastActivityDate = (ZonedDateTime)contents.get(contentId);
                if (lastActivityDate != null && !date.isAfter(lastActivityDate)) continue;
                contents.put(contentId, lastActivityDate);
                continue;
            }
            contents.put(contentId, date);
        }
        return contents.entrySet().stream().sorted((e1, e2) -> ((ZonedDateTime)e2.getValue()).compareTo((ChronoZonedDateTime)e1.getValue())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (ZonedDateTime)e.getValue(), (e1, e2) -> e2, LinkedHashMap::new));
    }

    private AmetysObjectIterable<Activity> _getContentActivities(String siteName, String tagName, FrequencyHelper.Frequency frequency, ZonedDateTime notificationDate) {
        ArrayList<Object> finalExprs = new ArrayList<Object>();
        finalExprs.addAll(FrequencyHelper.getDateExpressions(frequency, notificationDate));
        Expression[] activityTypeExpressions = (Expression[])this._activityTypeEP.getExtensionsIds().stream().map(arg_0 -> ((ActivityTypeExtensionPoint)this._activityTypeEP).getExtension(arg_0)).filter(PageUpdatedActivityType.class::isInstance).map(type -> new StringExpression("activityTypeId", Expression.Operator.EQ, type.getId())).toArray(Expression[]::new);
        finalExprs.add(new OrExpression(activityTypeExpressions));
        finalExprs.add(new StringExpression("contentTags", Expression.Operator.EQ, tagName));
        finalExprs.add(new StringExpression("siteName", Expression.Operator.EQ, siteName));
        AndExpression finalExpr = new AndExpression(finalExprs.toArray(new Expression[finalExprs.size()]));
        String xpathQuery = ActivityHelper.getActivityXPathQuery((Expression)finalExpr);
        return this._resolver.query(xpathQuery);
    }

    private ZonedDateTime _getNotificationDate(Subscription subscription) {
        FrequencyHelper.Frequency frequency = subscription.getFrequency();
        String time = (String)subscription.getValue("forcedHour", FrequencyHelper.getDefaultFrequencyTime());
        long day = (Long)subscription.getValue("forcedDay", FrequencyHelper.getDefaultFrequencyDay());
        SubscriptionType.FrequencyTiming timing = new SubscriptionType.FrequencyTiming(day, time);
        return FrequencyHelper.getNotificationDate(frequency, timing);
    }

    private Content _resolveSilently(String contentId) {
        try {
            return (Content)this._resolver.resolveById(contentId);
        }
        catch (Exception e) {
            this.getLogger().warn("Can't resolve content with id '{}'", (Object)contentId, (Object)e);
            return null;
        }
    }

    private Cache<TagSubscriptionKey, Map<String, ZonedDateTime>> _getCache() {
        return this._cacheManager.get(ROLE);
    }

    public void clearCache(String siteName, String tagName) {
        this._getCache().invalidate((Object)TagSubscriptionKey.of(siteName, tagName));
    }

    static class TagSubscriptionKey
    extends AbstractCacheKey {
        TagSubscriptionKey(String siteName, String tagName, FrequencyHelper.Frequency frequency, ZonedDateTime notificationDate) {
            super(new Object[]{siteName, tagName, frequency, notificationDate});
        }

        static TagSubscriptionKey of(String siteName, String tagName, FrequencyHelper.Frequency frequency, ZonedDateTime notificationDate) {
            return new TagSubscriptionKey(siteName, tagName, frequency, notificationDate);
        }

        static TagSubscriptionKey of(String siteName, String tagName) {
            return new TagSubscriptionKey(siteName, tagName, null, null);
        }
    }
}

