/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.page.notifier;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.User;
import org.ametys.plugins.pagesubscription.page.notifier.AbstractPageSubscriptionNotifier;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.activities.PageDeletedActivityType;
import org.ametys.web.repository.page.Page;

public class PageSubscriptionPageDeletedNotifier
extends AbstractPageSubscriptionNotifier {
    public boolean support(ActivityType activityType) {
        return activityType instanceof PageDeletedActivityType;
    }

    public boolean isAsync() {
        return false;
    }

    @Override
    protected String getSiteParameterId() {
        return "page-subscription-page-deletion";
    }

    @Override
    protected I18nizableText _getMailSubject(Activity activity, Page page) {
        ArrayList<String> i18nparam = new ArrayList<String>();
        i18nparam.add(page.getSite().getTitle());
        i18nparam.add(page.getTitle());
        return new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_DELETE_PAGE_SUBJECT", i18nparam);
    }

    @Override
    protected String _getMailHtmlBody(Activity activity, Page page, User author) throws IOException {
        return StandardMailBodyHelper.newHTMLBody().withLanguage(page.getSitemapName()).withTitle(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_DELETE_PAGE_BODY_TITLE", List.of(page.getTitle()))).withMessage(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_DELETE_PAGE_BODY", List.of(author.getFullName(), page.getTitle(), page.getSite().getTitle()))).build();
    }
}

