/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.page;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.core.observation.AbstractNotifierAction;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.pagesubscription.page.PageSubscriptionDAO;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.StringUtils;

public class PageSubscribeAction
extends AbstractNotifierAction {
    protected static final Pattern EMAIL_VALIDATOR = SendMailHelper.EMAIL_VALIDATION;
    protected static final Pattern TEXT_VALIDATOR = Pattern.compile("^\\s*$");
    protected AmetysObjectResolver _resolver;
    protected PageSubscriptionDAO _subscriptionDAO;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._subscriptionDAO = (PageSubscriptionDAO)((Object)smanager.lookup(PageSubscriptionDAO.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<I18nizableText> errors = new ArrayList<I18nizableText>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String action = request.getParameter("page-subscribe-action");
        result.put("action", action);
        String email = request.getParameter("email");
        if (email == null || !EMAIL_VALIDATOR.matcher(StringUtils.trimToEmpty((String)email.toLowerCase())).matches() || TEXT_VALIDATOR.matcher(StringUtils.trimToEmpty((String)email)).matches()) {
            errors.add(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_FORM_MAIL_ERROR_MAILBY"));
        } else {
            result.put("email", email);
            String pageId = request.getParameter("page-id");
            if (pageId == null) {
                throw new IllegalArgumentException("Unable to subscribe or unsubscribe to the page: cannot determine the current page");
            }
            String currentWorspace = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            try {
                Page page = (Page)this._resolver.resolveById(pageId);
                if (action.equals("subscribe")) {
                    this._subscriptionDAO.addSubscriber(page, email);
                } else if (action.equals("unsubscribe")) {
                    this._subscriptionDAO.removeSubscriber(page, email);
                }
            }
            catch (UnknownAmetysObjectException e) {
                throw new IllegalArgumentException("Unable to subscribe or unsubscribe to the unknown page with id '" + pageId + "'");
            }
            finally {
                RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWorspace);
            }
        }
        if (!errors.isEmpty()) {
            result.put("error", errors);
        }
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return EMPTY_MAP;
    }
}

