/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.page;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.jcr.DefaultPage;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class PageSubscriptionDAO
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = PageSubscriptionDAO.class.getName();
    private static final String __SUBSCRIBERS_PROPERTY_NAME = "ametys-internal:subscriberMails";
    private ObservationManager _observationManager;
    private CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        this._observationManager = (ObservationManager)smanager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public Set<String> getSubscribers(Page page) throws IllegalArgumentException {
        if (page instanceof JCRAmetysObject) {
            try {
                Node node = ((JCRAmetysObject)page).getNode();
                if (node.hasProperty(__SUBSCRIBERS_PROPERTY_NAME)) {
                    Value[] values = node.getProperty(__SUBSCRIBERS_PROPERTY_NAME).getValues();
                    try {
                        return Arrays.stream(values).map(LambdaUtils.wrap(Value::getString)).map(String::trim).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
                    }
                    catch (RuntimeException e) {
                        this.getLogger().error("Unable to retrieve subscribers for page of id '" + page.getId() + "'", e.getCause());
                    }
                }
            }
            catch (RepositoryException e) {
                this.getLogger().error("Unable to retrieve subscribers for page of id '" + page.getId() + "'", (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("The page of id '" + page.getId() + "' does not support subscription");
        }
        return new HashSet<String>();
    }

    public boolean isSubscriber(Page page, String email) {
        return this.getSubscribers(page).contains(email);
    }

    public void addSubscriber(Page page, String email) throws IllegalArgumentException {
        Set<String> subscribers = this.getSubscribers(page);
        subscribers.add(email);
        this.setSubscribers(page, subscribers);
    }

    public void removeSubscriber(Page page, String email) throws IllegalArgumentException {
        Set<String> subscribers = this.getSubscribers(page);
        subscribers.remove(email);
        this.setSubscribers(page, subscribers);
    }

    public void setSubscribers(Page page, Set<String> subscribers) throws IllegalArgumentException {
        if (page instanceof DefaultPage) {
            try {
                Node node = ((DefaultPage)page).getNode();
                String[] subscribersAsStringArray = subscribers.toArray(new String[subscribers.size()]);
                node.setProperty(__SUBSCRIBERS_PROPERTY_NAME, subscribersAsStringArray);
                ((DefaultPage)page).saveChanges();
                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                eventParams.put("page", page);
                eventParams.put("page.id", page.getId());
                this._observationManager.notify(new Event("page.updated", this._currentUserProvider.getUser(), eventParams));
            }
            catch (RepositoryException e) {
                this.getLogger().error("Unable to set subscribers for page of id '" + page.getId() + "'", (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException("The page of id '" + page.getId() + "' does not support subscription");
        }
    }
}

