/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.page.notifier;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.User;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.pagesubscription.page.notifier.AbstractPageSubscriptionNotifier;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.activities.PageResourcesUpdatedActivityType;
import org.ametys.web.repository.page.Page;

public class PageSubscriptionResourcesUpdatedNotifier
extends AbstractPageSubscriptionNotifier {
    private static final int __MAX_RESOURCE_LINK = 5;

    public boolean support(ActivityType activityType) {
        return activityType instanceof PageResourcesUpdatedActivityType;
    }

    @Override
    protected String getSiteParameterId() {
        return "page-subscription-attachments";
    }

    @Override
    protected I18nizableText _getMailSubject(Activity activity, Page page) {
        ArrayList<String> i18nparam = new ArrayList<String>();
        i18nparam.add(page.getTitle());
        String i18nKey = null;
        switch (activity.getEventType()) {
            case "resource.created": {
                String[] resourceIds = (String[])activity.getValue("resources-ids");
                int size = resourceIds.length;
                if (size > 1) {
                    i18nKey = "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_ADD_RESOURCES_SUBJECT";
                    i18nparam.add(String.valueOf(size));
                    break;
                }
                i18nKey = "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_ADD_RESOURCE_SUBJECT";
                break;
            }
            case "resource.updated": {
                i18nKey = "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_UPDATE_RESOURCE_SUBJECT";
                break;
            }
            case "resource.deleted": {
                i18nKey = "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_DELETE_RESOURCE_SUBJECT";
                break;
            }
        }
        return new I18nizableText("plugin.page-subscription", i18nKey, i18nparam);
    }

    @Override
    protected String _getMailHtmlBody(Activity activity, Page page, User author) throws IOException {
        String pageUrl = this._getAbsolutePageUrl(page);
        String pageTitle = page.getTitle();
        String siteTitle = page.getSite().getTitle();
        StandardMailBodyHelper.MailBodyBuilder bodyBuilder = StandardMailBodyHelper.newHTMLBody();
        switch (activity.getEventType()) {
            case "resource.created": {
                String[] resourceIds = (String[])activity.getValue("resources-ids");
                int size = resourceIds.length;
                if (size > 1) {
                    bodyBuilder.withTitle(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_ADD_RESOURCES_BODY_TITLE", List.of(String.valueOf(size))));
                    bodyBuilder.withMessage(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_ADD_RESOURCES_BODY", List.of(String.valueOf(size), pageTitle, siteTitle)));
                    bodyBuilder.withDetails(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_ADD_RESOURCES_DETAILS_TITLE"), this._getAbsoluteResourcesUrl(resourceIds, page), false);
                    break;
                }
                Resource resource = (Resource)this._resolver.resolveById(resourceIds[0]);
                String resourceName = resource.getName();
                String resourceUrl = this._getAbsoluteResourceUrl(resource, page);
                bodyBuilder.withTitle(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_ADD_RESOURCE_BODY_TITLE", List.of(resourceName)));
                bodyBuilder.addMessage(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_ADD_RESOURCE_BODY", List.of(resourceName, pageTitle, siteTitle)));
                bodyBuilder.addMessage(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_RESOURCE_DOWNLOAD", List.of(resourceUrl)));
                break;
            }
            case "resource.updated": {
                String[] updatedResourceIds = (String[])activity.getValue("resources-ids");
                Resource resource = (Resource)this._resolver.resolveById(updatedResourceIds[0]);
                String resourceName = resource.getName();
                String resourceUrl = this._getAbsoluteResourceUrl(resource, page);
                bodyBuilder.withTitle(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_UPDATE_RESOURCE_BODY_TITLE", List.of(resourceName)));
                bodyBuilder.addMessage(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_UPDATE_RESOURCE_BODY", List.of(resourceName, pageTitle, siteTitle)));
                bodyBuilder.addMessage(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_RESOURCE_DOWNLOAD", List.of(resourceUrl)));
                break;
            }
            case "resource.deleted": {
                String deletedResourceName = (String)activity.getValue("resource-name");
                bodyBuilder.withTitle(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_DELETE_RESOURCE_BODY_TITLE", List.of(deletedResourceName)));
                bodyBuilder.addMessage(new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_DELETE_RESOURCE_BODY", List.of(deletedResourceName, pageTitle, siteTitle)));
                break;
            }
        }
        return bodyBuilder.withLink(pageUrl, new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_PAGE_LINK_TITLE")).withLanguage(page.getSitemapName()).build();
    }

    private String _getAbsoluteResourcesUrl(String[] resourceIds, Page page) {
        StringBuilder sb = new StringBuilder();
        int nbResources = resourceIds.length;
        sb.append("<ul>");
        for (int i = 0; i < Math.min(nbResources, 5); ++i) {
            Resource resource = (Resource)this._resolver.resolveById(resourceIds[i]);
            sb.append("<li>").append("<a href=\"" + this._getAbsoluteResourceUrl(resource, page) + "\">").append(resource.getName()).append("</a>").append("</li>");
        }
        int nbOthers = nbResources - 5;
        if (nbOthers > 0) {
            I18nizableText moreLinks = new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_NOTIFICATION_MAIL_ADD_RESOURCES_MORE_LINKS", List.of(String.valueOf(nbOthers)));
            sb.append("<li>").append(this._i18nUtils.translate((I18nizable)moreLinks, page.getSitemapName())).append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    private String _getAbsoluteResourceUrl(Resource resource, Page page) {
        return page.getSite().getUrl() + "/_page-attachment" + "?id=" + URIUtils.encodeParameter((String)resource.getId()) + "&download=true";
    }
}

