<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <xsl:import href="plugin:cms://stylesheets/utils.xsl"/>
    
    <!-- +
         | Helper for contents container
         + -->
    <xsl:template name="contents">
        <xsl:param name="width">540</xsl:param>
        <xsl:param name="margin-top">10</xsl:param>
        <xsl:param name="margin-bottom">25</xsl:param>
        <xsl:param name="padding-top">25</xsl:param>
        <xsl:param name="padding-bottom">25</xsl:param>
        <xsl:param name="padding-left">30</xsl:param>
        <xsl:param name="padding-right">30</xsl:param>
        <xsl:param name="background-color">#F9F9F9</xsl:param>
        <xsl:param name="border-radius">8px</xsl:param>
        
        <xsl:call-template name="msoif-open">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        
        <div style="max-width: {$width}px; margin: 0px auto">
            <table>
                <xsl:call-template name="table-layout-attributes" />
                <tbody>
                    <xsl:call-template name="row-vertical-spacer">
                        <xsl:with-param name="height" select="$margin-top"/>
                    </xsl:call-template>
                    <tr>
                        <td>
                            <xsl:call-template name="td-layout-attributes" />
                    
                            <xsl:call-template name="msoif-open">
                                <xsl:with-param name="width" select="$width"/>
                            </xsl:call-template>
                            
                            <div style="max-width: {$width}px; margin: 0px auto">
                              <table>
                                <xsl:call-template name="table-layout-attributes" />
                                <tbody>
                                  <tr>
                                    <td style="background-color: {$background-color}; direction: ltr; font-size: 0px; padding: 0px; word-break: break-word; border-radius: {$border-radius}; overflow: hidden;">
                                        <table>
                                            <xsl:call-template name="table-layout-attributes" />
                                            <tbody>
                                              <xsl:call-template name="row-vertical-spacer">
                                                    <xsl:with-param name="height" select="$padding-top"/>
                                                    <xsl:with-param name="colspan">3</xsl:with-param>
                                              </xsl:call-template>
                                              <tr>
                                                <xsl:call-template name="row-horizontal-spacer">
                                                    <xsl:with-param name="width" select="$padding-left"/>
                                                </xsl:call-template>
                                                <td>
                                                    <xsl:call-template name="td-layout-attributes" />
                                                    <xsl:apply-templates select="content/content" mode="content"/>
                                                </td>
                                                <xsl:call-template name="row-horizontal-spacer">
                                                    <xsl:with-param name="width" select="$padding-right"/>
                                                </xsl:call-template>
                                              </tr>
                                              <xsl:call-template name="row-vertical-spacer">
                                                  <xsl:with-param name="height" select="$padding-bottom"/>
                                                  <xsl:with-param name="colspan">3</xsl:with-param>
                                              </xsl:call-template>
                                            </tbody>
                                      </table>
                                    </td>
                                  </tr>
                                </tbody>
                              </table>
                            </div>
                            <xsl:call-template name="msoif-close"/>
                        </td>
                    </tr>
                    <xsl:call-template name="row-vertical-spacer">
                        <xsl:with-param name="height" select="$margin-bottom"/>
                    </xsl:call-template>
            </tbody>
        </table>
        </div>
    </xsl:template>
</xsl:stylesheet>