<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    <xsl:template match="content" mode="content">
        <table>
            <xsl:call-template name="table-layout-attributes" />
            <tbody>
                <tr>
                    <td>
                        <xsl:call-template name="td-layout-attributes"/>
                        <table>
                            <xsl:call-template name="table-layout-attributes" />
                            <tbody>
                                <tr>
                                    <td>
                                        <xsl:call-template name="td-layout-attributes">
                                            <xsl:with-param name="vertical-align">top</xsl:with-param>
                                        </xsl:call-template>
                                        <table>
                                            <xsl:call-template name="table-layout-attributes" />
                                            <tbody>
                                                <xsl:apply-templates select="." mode="title"/>      
                                                <xsl:apply-templates select="." mode="abstract"/>
                                                <xsl:apply-templates select="." mode="link"/>
                                            </tbody>
                                         </table>
                                    </td>
                                    
                                    <xsl:apply-templates select="." mode="image"/>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
                <xsl:if test="position() != last()">
                    <!--  separator -->
                    <tr>
                        <td style="padding-top: 20px; padding-bottom: 20px;">
                            <hr style="border: none; border-top: 2px solid #e6e6e6;"/>
                        </td>
                    </tr>
                </xsl:if>
            </tbody>
        </table>
    </xsl:template>

    <xsl:template match="content" mode="image">
        <xsl:param name="image" select="values/illustration/image"/>
        <xsl:param name="imageWidth">140</xsl:param>
        <xsl:param name="imageHeight">100</xsl:param>
        
        <xsl:if test="$image">
            <xsl:call-template name="row-horizontal-spacer">
                <xsl:with-param name="width">10</xsl:with-param>
            </xsl:call-template>
            
            <td style="direction: ltr;font-size: 0px;padding: 0px;word-break: break-word;vertical-align: top; width: {$imageWidth}">
                <xsl:variable name="uri"><xsl:value-of select="$image/path"/><xsl:if test="$image/type = 'attribute'">?objectId=<xsl:value-of select="id"/></xsl:if></xsl:variable>
                <img width="{$imageWidth}" height="{$imageHeight}" src="{resolver:resolveCroppedImageAsBase64($image/type, $uri, $imageHeight, $imageWidth)}" alt=""/>
            </td>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="content" mode="title">
        <xsl:param name="margin-top">0</xsl:param>
        <xsl:param name="margin-bottom">10</xsl:param>
        <xsl:param name="margin-left">20</xsl:param>
        <xsl:param name="margin-right">20</xsl:param>
        <xsl:param name="title" select="values/title"/>
        
        <tr>
            <td>
                <xsl:call-template name="td-layout-attributes"/>
                <div>
                    <xsl:call-template name="content-title-style"/>
                    <xsl:value-of select="$title" disable-output-escaping="yes"/>
                </div>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template match="content" mode="abstract">
        <xsl:param name="content" select="values/content/value"/>
        
        <xsl:call-template name="row-vertical-spacer">
            <xsl:with-param name="height">5</xsl:with-param>
        </xsl:call-template>
        <tr>
            <td>
                <xsl:call-template name="td-layout-attributes"/>
                <div>
                    <xsl:call-template name="content-text-style"/>
                    <xsl:call-template name="common-utils-simpletext">
                        <xsl:with-param name="defaultText" select="$content"/>                
                        <xsl:with-param name="maxDefaultTextSize" select="200"/>                
                    </xsl:call-template>
                </div>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template match="content" mode="link">
        <xsl:param name="pageId" select="pageId"/>
        
        <xsl:if test="$pageId">
            <xsl:call-template name="row-vertical-spacer">
                <xsl:with-param name="height">5</xsl:with-param>
            </xsl:call-template>
            <tr>
                <td>
                    <xsl:call-template name="td-layout-attributes"/>
                    <div>
                        <xsl:call-template name="content-link-style"/>
                        <a href="{resolver:resolve('page', $pageId, 'false', 'true')}">
                            <xsl:call-template name="content-link-style"/>
                            <i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIPTION_MAIL_TAG_NOTIFICATIONS_READ_MORE" i18n:catalogue="plugin.page-subscription"/>
                        </a>
                    </div>
                </td>
            </tr>
            <br/>
            
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>