/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.pagesubscription.schedulable;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.plugins.core.impl.schedule.StaticRunnable;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper.Frequency;
import org.ametys.plugins.pagesubscription.type.SubscriptionType.FrequencyTiming;
import org.ametys.runtime.config.Config;

/**
 * Runnable to send the notification summary
 */
public class SendNotificationSummaryRunnable extends StaticRunnable
{
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        super.configure(configuration);
        
        String frequency = configuration.getChild("frequency").getValue(Frequency.DAILY.name());
        // Here we do not user FrequencyHelper because, the initialization is after this methods
        _cronExpression = FrequencyHelper.getCron(Frequency.valueOf(frequency), new FrequencyTiming(Config.getInstance().getValue("page-subscription.frequency.day", true, 1L), Config.getInstance().getValue("page-subscription.frequency.hour", true, "10:00")));
    }
}
