/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.type.SubscriptionType;
import org.ametys.plugins.repository.query.expression.DateExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FrequencyHelper
implements Component,
Serviceable,
Initializable,
LogEnabled {
    protected static I18nUtils _i18nUtils;
    private static long _frequencyDay;
    private static String _frequencyTime;
    private static Logger _logger;

    public void enableLogging(Logger logger) {
        _logger = logger;
    }

    public void service(ServiceManager manager) throws ServiceException {
        _i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
    }

    public void initialize() throws Exception {
        _frequencyDay = (Long)Config.getInstance().getValue("page-subscription.frequency.day", true, (Object)1L);
        _frequencyTime = (String)Config.getInstance().getValue("page-subscription.frequency.hour", true, (Object)"10:00");
    }

    public static long getDefaultFrequencyDay() {
        return _frequencyDay;
    }

    public static String getDefaultFrequencyTime() {
        return _frequencyTime;
    }

    private static I18nizableText _getEntry(long day) {
        try {
            ElementDefinition def = (ElementDefinition)Config.getModel().getChild("page-subscription.frequency.day");
            return def.getEnumerator().getEntry((Object)day);
        }
        catch (Exception e) {
            _logger.error("An error occurred getting day from value '" + day + "'", (Throwable)e);
            return null;
        }
    }

    public static void saxFrequencies(ContentHandler contentHandler) throws SAXException {
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"frequencies");
        for (Frequency frequency : Frequency.values()) {
            if (frequency == Frequency.INSTANT) continue;
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("name", frequency.name());
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"frequency", (Attributes)attrs);
            FrequencyHelper.getLabel(frequency).toSAX(contentHandler, "label");
            FrequencyHelper.getSmartLabel(frequency).toSAX(contentHandler, "smartLabel");
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"frequency");
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"frequencies");
    }

    public static I18nizableText getLabel(Frequency frequency) {
        return new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_FREQUENCY_LABEL_" + frequency.name());
    }

    public static I18nizableText getSmartLabel(Frequency frequency) {
        return FrequencyHelper.getSmartLabel(frequency, null);
    }

    public static I18nizableText getSmartLabel(Frequency frequency, SubscriptionType.FrequencyTiming timing) {
        HashMap<String, I18nizableText> params = new HashMap<String, I18nizableText>();
        I18nizableText hourI18n = timing != null && timing.time() != null ? new I18nizableText(FrequencyHelper._getHour(timing.time())) : new I18nizableText(FrequencyHelper._getHour(_frequencyTime));
        switch (frequency) {
            case DAILY: {
                params.put("hour", hourI18n);
                break;
            }
            case WEEKLY: 
            case MONTHLY: {
                I18nizableText dayI18n;
                I18nizableText i18nizableText = dayI18n = timing != null && timing.day() != null ? FrequencyHelper._getEntry(timing.day()) : FrequencyHelper._getEntry(_frequencyDay);
                if (dayI18n != null) {
                    params.put("day", dayI18n);
                }
                params.put("hour", hourI18n);
                break;
            }
        }
        return new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_FREQUENCY_SMART_LABEL_" + frequency.name(), params);
    }

    public static I18nizableText getFullLabel(Frequency frequency, List<BroadcastChannelHelper.BroadcastChannel> channels) {
        return FrequencyHelper.getFullLabel(frequency, channels, null);
    }

    public static I18nizableText getFullLabel(Frequency frequency, List<BroadcastChannelHelper.BroadcastChannel> channels, SubscriptionType.FrequencyTiming timing) {
        I18nizableText dayI18n;
        HashMap<String, I18nizableText> params = new HashMap<String, I18nizableText>();
        I18nizableText i18nizableText = dayI18n = timing != null && timing.day() != null ? FrequencyHelper._getEntry(timing.day()) : FrequencyHelper._getEntry(_frequencyDay);
        if (dayI18n != null) {
            params.put("day", dayI18n);
        }
        I18nizableText broadcastChannelKey = new I18nizableText("plugin.page-subscription", FrequencyHelper._getBroadcastChannelKey(channels));
        params.put("broadcastChannel", broadcastChannelKey);
        return new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_FREQUENCY_" + frequency.name() + "_AND_BROADCAST_CHANNEL_LABEL", params);
    }

    private static String _getBroadcastChannelKey(List<BroadcastChannelHelper.BroadcastChannel> channels) {
        if (channels.contains((Object)BroadcastChannelHelper.BroadcastChannel.MAIL) && channels.contains((Object)BroadcastChannelHelper.BroadcastChannel.SITE)) {
            return "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_BROADCAST_CHANNEL_MSG_SITE_AND_MAIL";
        }
        if (channels.contains((Object)BroadcastChannelHelper.BroadcastChannel.SITE)) {
            return "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_BROADCAST_CHANNEL_MSG_SITE";
        }
        if (channels.contains((Object)BroadcastChannelHelper.BroadcastChannel.MAIL)) {
            return "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_BROADCAST_CHANNEL_MSG_MAIL";
        }
        return "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_BROADCAST_CHANNEL_MSG_NONE";
    }

    private static String _getHour(String time) {
        String stringFormat = _i18nUtils.translate((I18nizable)new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_FREQUENCY_HOUR_FORMAT"));
        SimpleDateFormat defaultFormat = new SimpleDateFormat("HH:mm");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringFormat);
        try {
            return simpleDateFormat.format(defaultFormat.parse(time));
        }
        catch (ParseException e) {
            return time;
        }
    }

    public static SubscriptionType.FrequencyTiming getTiming(Subscription subscription) {
        SubscriptionType.FrequencyTiming forceFrequencyTiming = subscription.getForceFrequencyTiming();
        long day = forceFrequencyTiming.day() != null ? forceFrequencyTiming.day() : FrequencyHelper.getDefaultFrequencyDay();
        String time = StringUtils.isNotBlank((CharSequence)forceFrequencyTiming.time()) ? forceFrequencyTiming.time() : FrequencyHelper.getDefaultFrequencyTime();
        return new SubscriptionType.FrequencyTiming(day, time);
    }

    public static String getCron(Frequency frequency, SubscriptionType.FrequencyTiming frequencyTiming) {
        int minutes = (int)frequencyTiming.minutes();
        int hour = (int)frequencyTiming.hour();
        switch (frequency) {
            case DAILY: {
                CronScheduleBuilder builder = CronScheduleBuilder.dailyAtHourAndMinute((int)hour, (int)minutes);
                CronTrigger trigger = (CronTrigger)builder.build();
                return trigger.getCronExpression();
            }
            case WEEKLY: {
                CronScheduleBuilder builder = CronScheduleBuilder.weeklyOnDayAndHourAndMinute((int)FrequencyHelper._getDay(frequencyTiming), (int)hour, (int)minutes);
                CronTrigger trigger = (CronTrigger)builder.build();
                return trigger.getCronExpression();
            }
            case MONTHLY: {
                return "0 " + minutes + " " + hour + " ? * " + FrequencyHelper._getDay(frequencyTiming) + "#1";
            }
        }
        throw new IllegalArgumentException("Can create subscription schedulable with the given frequency: " + frequency);
    }

    private static int _getDay(SubscriptionType.FrequencyTiming frequencyTiming) {
        int day = frequencyTiming.day().intValue();
        return day == 7 ? 1 : day + 1;
    }

    public static List<Expression> getDateExpressions(Frequency frequency, ZonedDateTime notificationDate) {
        ArrayList<Expression> dateExprs = new ArrayList<Expression>();
        switch (frequency) {
            case INSTANT: {
                ZonedDateTime startDate = notificationDate.minusMonths(6L);
                dateExprs.add((Expression)new DateExpression("date", Expression.Operator.GT, DateUtils.asDate((ZonedDateTime)startDate)));
                break;
            }
            case DAILY: {
                ZonedDateTime startDate = notificationDate.minusDays(1L);
                dateExprs.add((Expression)new DateExpression("date", Expression.Operator.GT, DateUtils.asDate((ZonedDateTime)startDate)));
                dateExprs.add((Expression)new DateExpression("date", Expression.Operator.LT, DateUtils.asDate((ZonedDateTime)notificationDate)));
                break;
            }
            case WEEKLY: {
                ZonedDateTime startDate = notificationDate.minusDays(7L);
                dateExprs.add((Expression)new DateExpression("date", Expression.Operator.GT, DateUtils.asDate((ZonedDateTime)startDate)));
                dateExprs.add((Expression)new DateExpression("date", Expression.Operator.LT, DateUtils.asDate((ZonedDateTime)notificationDate)));
                break;
            }
            case MONTHLY: {
                ZonedDateTime startDate = notificationDate.minusMonths(1L);
                dateExprs.add((Expression)new DateExpression("date", Expression.Operator.GT, DateUtils.asDate((ZonedDateTime)startDate)));
                dateExprs.add((Expression)new DateExpression("date", Expression.Operator.LT, DateUtils.asDate((ZonedDateTime)notificationDate)));
                break;
            }
        }
        return dateExprs;
    }

    public static ZonedDateTime getNotificationDate(Frequency frequency, SubscriptionType.FrequencyTiming timing) {
        ZonedDateTime now = ZonedDateTime.now();
        long day = timing.day();
        int hour = (int)timing.hour();
        int minute = (int)timing.minutes();
        switch (frequency) {
            case INSTANT: {
                return now.truncatedTo(ChronoUnit.DAYS);
            }
            case DAILY: {
                return FrequencyHelper._isCurrentDayBeforeDailyTime(now, hour, minute) ? now.minusDays(1L).truncatedTo(ChronoUnit.DAYS).withHour(hour).withMinute(minute) : now.truncatedTo(ChronoUnit.DAYS).withHour(hour).withMinute(minute);
            }
            case WEEKLY: {
                ZonedDateTime dayOfWeek = now.with(TemporalAdjusters.previousOrSame(DayOfWeek.of((int)day)));
                return dayOfWeek.getDayOfMonth() == now.getDayOfMonth() && FrequencyHelper._isCurrentDayBeforeDailyTime(now, hour, minute) ? dayOfWeek.minusDays(7L).truncatedTo(ChronoUnit.DAYS).withHour(hour).withMinute(minute) : dayOfWeek.truncatedTo(ChronoUnit.DAYS).withHour(hour).withMinute(minute);
            }
            case MONTHLY: {
                ZonedDateTime dayOfMonth = now.with(TemporalAdjusters.firstInMonth(DayOfWeek.of((int)day)));
                return now.getDayOfMonth() < dayOfMonth.getDayOfMonth() || (long)now.getDayOfMonth() == day && FrequencyHelper._isCurrentDayBeforeDailyTime(now, hour, minute) ? dayOfMonth.minusMonths(1L).truncatedTo(ChronoUnit.DAYS).withHour(hour).withMinute(minute) : dayOfMonth.truncatedTo(ChronoUnit.DAYS).withHour(hour).withMinute(minute);
            }
        }
        return null;
    }

    private static boolean _isCurrentDayBeforeDailyTime(ZonedDateTime now, int hour, int minute) {
        return now.getHour() < hour || now.getHour() == hour && now.getMinute() < minute;
    }

    public static enum Frequency {
        INSTANT,
        DAILY,
        WEEKLY,
        MONTHLY;

    }
}

