/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.dao;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.SubscriptionException;
import org.ametys.plugins.pagesubscription.context.TagSubscriptionContext;
import org.ametys.plugins.pagesubscription.dao.AbstractSubscriptionsDAO;
import org.ametys.plugins.pagesubscription.type.SubscriptionType;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.pagesubscription.type.TagSubscriptionType;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.runtime.config.Config;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class ForceTagSubscriptionsDAO
extends AbstractSubscriptionsDAO
implements Initializable {
    private static final String _FORCE_TAG_SUBSCRIPTION_RIGHT_ID = "Page_Subscription_Rights_Force_Subscriptions";
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;
    protected SiteManager _siteManager;
    protected TagSubscriptionType _tagSubscriptionType;
    private Long _day;
    private String _hour;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)smanager.lookup(SubscriptionTypeExtensionPoint.ROLE));
        this._tagSubscriptionType = (TagSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.tag");
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
    }

    public void initialize() throws Exception {
        this._day = (Long)Config.getInstance().getValue("plugin.web.subscription.day", true, (Object)2L);
        this._hour = (String)Config.getInstance().getValue("plugin.web.subscription.hour", true, (Object)"10:00");
    }

    @Callable(rights={""})
    public Map<String, Object> getFrequencyTiming() {
        return Map.of("day", this._day, "hour", this._hour);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable(rights={"Page_Subscription_Rights_Force_Subscriptions"}, context="/${WorkspaceName}")
    public Map<String, Object> forceGroupSubscription(String siteName, String groupId, String tagName, String frequency, String forcedDay, String forcedHour, List<String> broadcastChannelNames) throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            Site site = this._siteManager.getSite(siteName);
            GroupIdentity group = GroupIdentity.stringToGroupIdentity((String)groupId);
            TagSubscriptionContext context = TagSubscriptionContext.newInstance().withTag(tagName);
            List<BroadcastChannelHelper.BroadcastChannel> broadcastChannels = broadcastChannelNames.stream().map(c -> BroadcastChannelHelper.BroadcastChannel.valueOf(c)).toList();
            Long day = StringUtils.isNotBlank((CharSequence)forcedDay) ? Long.valueOf(forcedDay) : this._day;
            String hour = StringUtils.isNotBlank((CharSequence)forcedHour) ? forcedHour : this._hour;
            Subscription subscription = this._tagSubscriptionType.forceSubscription(site, group, FrequencyHelper.Frequency.valueOf(frequency), new SubscriptionType.FrequencyTiming(day, hour), broadcastChannels, context);
            Map<String, Object> map = Map.of("success", true, "subscription", this._tagSubscriptionType.subscriptionToJSON(subscription));
            return map;
        }
        catch (SubscriptionException e) {
            this.getLogger().error("Unable to force group subscription for site name '{}' and group id '{}'", new Object[]{siteName, groupId, e});
            Map<String, Object> map = Map.of("success", false, "type", e.getType().name());
            return map;
        }
        catch (Exception e) {
            this.getLogger().error("Unable to force group subscription for site name '{}' and group id '{}'", new Object[]{siteName, groupId, e});
            Map<String, Object> map = Map.of("success", false);
            return map;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }

    @Callable(rights={"Page_Subscription_Rights_Force_Subscriptions"}, context="/${WorkspaceName}")
    public List<Map<String, Object>> getForceGroupSubscriptions(String siteName) {
        Site site = this._siteManager.getSite(siteName);
        return this._tagSubscriptionType.getGroupsSubscriptions(site, Set.of(), true, TagSubscriptionContext.newInstance()).stream().map(this._tagSubscriptionType::subscriptionToJSON).toList();
    }

    @Override
    @Callable(rights={"Page_Subscription_Rights_Force_Subscriptions"}, context="/${WorkspaceName}")
    public Map<String, Object> getSubscription(String subscriptionId) {
        return this.getSubscription(subscriptionId, false);
    }

    @Callable(rights={"Page_Subscription_Rights_Force_Subscriptions"}, context="/${WorkspaceName}")
    public Map<String, Object> editForceSubscription(String subscriptionId, String frequency, String forcedDay, String forcedHour, List<String> broadcastChannels) {
        Long day = StringUtils.isNotBlank((CharSequence)forcedDay) ? Long.valueOf(forcedDay) : this._day;
        String hour = StringUtils.isNotBlank((CharSequence)forcedHour) ? forcedHour : this._hour;
        return this.editSubscription(subscriptionId, frequency, new SubscriptionType.FrequencyTiming(day, hour), broadcastChannels, false);
    }

    @Override
    @Callable(rights={"Page_Subscription_Rights_Force_Subscriptions"}, context="/${WorkspaceName}")
    public boolean unsubscribe(String subscriptionId) throws Exception {
        return this.unsubscribe(subscriptionId, false);
    }
}

