/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.observation;

import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.pagesubscription.notification.PageNotificationsHelper;
import org.ametys.plugins.pagesubscription.notification.TagNotificationsHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.activities.AbstractPageActivityType;
import org.ametys.web.activities.PageUpdatedActivityType;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ClearNotificationsCacheOnPageActivityObserver
extends AbstractLogEnabled
implements Observer,
Serviceable {
    protected TagNotificationsHelper _tagNotificationsHelper;
    protected PageNotificationsHelper _pageNotificationsHelper;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._tagNotificationsHelper = (TagNotificationsHelper)((Object)manager.lookup(TagNotificationsHelper.ROLE));
        this._pageNotificationsHelper = (PageNotificationsHelper)((Object)manager.lookup(PageNotificationsHelper.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public boolean supports(Event event) {
        if ("activity.created".equals(event.getId())) {
            Activity activity = (Activity)event.getArguments().get("activity");
            return activity != null && activity.getActivityType() instanceof AbstractPageActivityType;
        }
        return false;
    }

    public int getPriority(Event event) {
        return 0;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Activity activity = (Activity)event.getArguments().get("activity");
        String pageId = (String)activity.getValue("pageId");
        Page page = (Page)this._resolver.resolveById(pageId);
        this._pageNotificationsHelper.clearCache(page.getSiteName(), page.getId());
        if (activity.getActivityType() instanceof PageUpdatedActivityType) {
            String string;
            String contentId = (String)activity.getValue("contentId");
            Content content = (Content)this._resolver.resolveById(contentId);
            if (content instanceof WebContent) {
                WebContent webContent = (WebContent)content;
                string = webContent.getSiteName();
            } else {
                string = null;
            }
            String siteName = string;
            for (String tagName : content.getTags()) {
                this._tagNotificationsHelper.clearCache(siteName, tagName);
            }
        }
    }
}

