/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.schedulable.tag;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.cms.tag.CMSTag;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.mail.TagSubscriptionSummaryMailBodyHelper;
import org.ametys.plugins.pagesubscription.notification.TagNotificationsHelper;
import org.ametys.plugins.pagesubscription.type.SubscriptionType;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.pagesubscription.type.TagSubscriptionType;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.page.PageDAO;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.quartz.JobExecutionContext;

public abstract class AbstractSendTagNotificationSummarySchedulable
extends AbstractStaticSchedulable {
    public static final String SUBSCRIPTIONS_CONFIG_PAGE_TAG = "TAG_SUBSCRIPTIONS_CONFIG";
    protected I18nizableText _mailSubject;
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;
    protected TagSubscriptionType _tagSubscriptionType;
    protected SiteManager _siteManager;
    protected I18nUtils _i18nUtils;
    protected TagNotificationsHelper _tagNotificationHelper;
    protected PageDAO _pageDAO;
    protected AmetysObjectResolver _resolver;
    protected RenderingContextHandler _renderingContextHandler;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)manager.lookup(SubscriptionTypeExtensionPoint.ROLE));
        this._tagSubscriptionType = (TagSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.tag");
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._tagNotificationHelper = (TagNotificationsHelper)((Object)manager.lookup(TagNotificationsHelper.ROLE));
        this._pageDAO = (PageDAO)manager.lookup(PageDAO.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._renderingContextHandler = (RenderingContextHandler)manager.lookup(RenderingContextHandler.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this._mailSubject = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("mail-subject"), (String)("plugin." + this._pluginName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        FrequencyHelper.Frequency frequency = this.getFrequency(context);
        SubscriptionType.FrequencyTiming timing = this.getFrequencyTiming(context);
        ZonedDateTime notificationDate = FrequencyHelper.getNotificationDate(frequency, timing);
        for (Site site : this.getSiteToNotify(context)) {
            Request request = ContextHelper.getRequest((Context)this._context);
            request.setAttribute("site", (Object)site.getName());
            RenderingContext currentContext = this._renderingContextHandler.getRenderingContext();
            try {
                this._renderingContextHandler.setRenderingContext(RenderingContext.FRONT);
                Map<CMSTag, Set<UserIdentity>> subscribersByTag = this.getSubscribersByTag(context, site, frequency);
                for (CMSTag tag : subscribersByTag.keySet()) {
                    for (UserIdentity subscriber : subscribersByTag.get(tag)) {
                        Map<Content, ZonedDateTime> updatedContents = this._tagNotificationHelper.getUpdatedContents(site.getName(), tag.getName(), frequency, timing, subscriber);
                        if (updatedContents.isEmpty()) continue;
                        Set<Content> contents = updatedContents.keySet();
                        String lang = this._getLanguage(contents);
                        String subject = this._i18nUtils.translate(this._getI18nSubject(site, tag), lang);
                        String body = this.getMailBody(site, tag, contents, frequency, notificationDate, lang);
                        User user = this._userManager.getUser(subscriber);
                        if (user == null) continue;
                        SendMailHelper.newMail().withRecipient(user.getEmail()).withSubject(subject).withHTMLBody(body).withInlineCSS(false).withAsync(true).sendMail();
                    }
                }
            }
            finally {
                this._renderingContextHandler.setRenderingContext(currentContext);
            }
        }
    }

    private String _getLanguage(Set<Content> contents) {
        return contents.stream().map(Content::getLanguage).findFirst().get();
    }

    protected abstract List<Site> getSiteToNotify(JobExecutionContext var1);

    protected abstract FrequencyHelper.Frequency getFrequency(JobExecutionContext var1);

    protected abstract SubscriptionType.FrequencyTiming getFrequencyTiming(JobExecutionContext var1);

    protected abstract Map<CMSTag, Set<UserIdentity>> getSubscribersByTag(JobExecutionContext var1, Site var2, FrequencyHelper.Frequency var3);

    protected I18nizable _getI18nSubject(Site site, CMSTag tag) {
        Map<String, I18nizableText> params = Map.of("tag", tag.getTitle(), "site", new I18nizableText(site.getTitle()));
        return new I18nizableText(this._mailSubject.getCatalogue(), this._mailSubject.getKey(), params);
    }

    protected String getMailBody(Site site, CMSTag tag, Set<Content> updatedContents, FrequencyHelper.Frequency frequency, ZonedDateTime notificationDate, String lang) throws IOException {
        TagSubscriptionSummaryMailBodyHelper.MailBodyBuilder bodyBuilder = TagSubscriptionSummaryMailBodyHelper.newHTMLBody().withLanguage(lang).withTitle(this._getMailBodyTitle(tag)).withHint(this._getMailBodyHint(frequency, notificationDate, lang)).withContents(updatedContents).withLink(site.getUrl(), new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIPTION_MAIL_NOTIFICATIONS_MAIL_SITE_LINK"));
        Optional<String> pageTagUrl = this._pageDAO.findPagedIdsByTag(site.getName(), lang, SUBSCRIPTIONS_CONFIG_PAGE_TAG).stream().map(id -> ResolveURIComponent.resolve((String)"page", (String)id, (boolean)false, (boolean)true)).findFirst();
        if (pageTagUrl.isPresent()) {
            bodyBuilder.withFooterLink(pageTagUrl.get(), new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIPTION_MAIL_TAG_NOTIFICATIONS_MAIL_PREFERENCE_LINK"), "core-ui", "img/mail/icon-letter.png");
        }
        return bodyBuilder.build();
    }

    protected I18nizableText _getMailBodyTitle(CMSTag tag) {
        Map<String, I18nizableText> params = Map.of("tag", tag.getTitle());
        return new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIPTION_MAIL_TAG_NOTIFICATIONS_MAIL_TITLE", params);
    }

    protected I18nizableText _getMailBodyHint(FrequencyHelper.Frequency frequency, ZonedDateTime notificationDate, String lang) {
        String pattern = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIPTION_MAIL_DATE_FORMAT"), lang);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        Map<String, I18nizableText> params = Map.of("date", new I18nizableText(formatter.format(notificationDate)));
        String key = "PLUGINS_PAGE_SUBSCRIPTION_MAIL_TAG_NOTIFICATIONS_MAIL_MESSAGE_" + frequency.name();
        return new I18nizableText("plugin.page-subscription", key, params);
    }
}

