/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.schedulable.tag;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.tag.CMSTag;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.schedulable.tag.AbstractSendTagNotificationSummarySchedulable;
import org.ametys.plugins.pagesubscription.type.SubscriptionType;
import org.ametys.web.repository.site.Site;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class SendGroupTagNotificationSummarySchedulable
extends AbstractSendTagNotificationSummarySchedulable {
    @Override
    protected List<Site> getSiteToNotify(JobExecutionContext context) {
        Subscription subscription = this._getSubscription(context);
        return List.of(subscription.getSite());
    }

    @Override
    protected FrequencyHelper.Frequency getFrequency(JobExecutionContext context) {
        Subscription subscription = this._getSubscription(context);
        return subscription.getFrequency();
    }

    @Override
    protected SubscriptionType.FrequencyTiming getFrequencyTiming(JobExecutionContext context) {
        Subscription subscription = this._getSubscription(context);
        return FrequencyHelper.getTiming(subscription);
    }

    @Override
    protected Map<CMSTag, Set<UserIdentity>> getSubscribersByTag(JobExecutionContext context, Site site, FrequencyHelper.Frequency frequency) {
        Subscription subscription = this._getSubscription(context);
        return Map.of(this._tagSubscriptionType.getTarget(subscription), this._tagSubscriptionType.getSubscribers(subscription));
    }

    private Subscription _getSubscription(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String subscriptionId = (String)jobDataMap.get((Object)"parameterValues#subscriptionId");
        return (Subscription)this._resolver.resolveById(subscriptionId);
    }
}

