/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.pagesubscription.context;

import org.ametys.plugins.pagesubscription.type.TagSubscriptionType;

/**
 * Class to represent a context for {@link TagSubscriptionType}
 */
public class TagSubscriptionContext extends SubscriptionContext
{
    /**  The tag name */
    protected String _tagName;
    /** The root tag name */
    protected String _rootTagName;
    /** The site name */
    protected String _siteName;
    
    /**
     * Creates a new instance of a {@link TagSubscriptionContext}
     */
    protected TagSubscriptionContext()
    {
        super();
    }
    
    /**
     * Creates a new instance of a {@link TagSubscriptionContext}
     * @return the created instance
     */
    public static TagSubscriptionContext newInstance()
    {
        return new TagSubscriptionContext();
    }
    
    /**
     * Add a tag to the context
     * @param tagName the tag name
     * @return the context
     */
    public TagSubscriptionContext withTag(String tagName)
    {
        _tagName = tagName;
        return this;
    }
    
    /**
     * Add a root tag to the context
     * @param rootTagName the tag name
     * @return the context
     */
    public TagSubscriptionContext withRootTag(String rootTagName)
    {
        _rootTagName = rootTagName;
        return this;
    }
    
    /**
     * Add site name to context
     * @param siteName the site name
     * @return the context
     */
    public TagSubscriptionContext withSiteName(String siteName)
    {
        _siteName = siteName;
        return this;
    }
    
    /**
     * Get the tag name
     * @return the tag name
     */
    public String getTagName()
    {
        return _tagName;
    }
    
    /**
     * Get the tag name
     * @return the tag name
     */
    public String getRootTagName()
    {
        return _rootTagName;
    }
    
    /**
     * Get the tag name
     * @return the tag name
     */
    public String getSiteName()
    {
        return _siteName;
    }
}
