/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.mail;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.content.WebContent;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class TagSubscriptionSummaryMailBodyHelper
implements Contextualizable,
Serviceable,
Initializable {
    protected static Context _context;
    private static SourceResolver _srcResolver;
    private static ContentTypesHelper _contentTypesHelper;
    private static TagSubscriptionSummaryMailBodyHelper __instance;

    public void contextualize(Context context) {
        _context = context;
    }

    public void initialize() throws Exception {
        __instance = this;
    }

    public void service(ServiceManager manager) throws ServiceException {
        _srcResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        _contentTypesHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
    }

    public String getMailBodyUri() {
        Request request = ContextHelper.getRequest((Context)_context);
        String siteName = WebHelper.getSiteName((Request)request);
        return "cocoon://_plugins/page-subscription/" + siteName + "/wrapped-mail/subscriptions/body.html";
    }

    public static MailBodyBuilder newHTMLBody() {
        return new MailBodyBuilder(__instance.getMailBodyUri());
    }

    public static class MailBodyBuilder {
        private Object _title;
        private List<Object> _messages;
        private Set<Content> _contents;
        private I18nizableText _linkText;
        private String _linkUrl;
        private I18nizableText _footerLinkText;
        private String _footerLinkUrl;
        private String _footerImgPluginName;
        private String _footerImgPath;
        private String _lang;
        private String _uri;
        private String _viewName = "abstract";
        private I18nizableText _hintMessage;

        MailBodyBuilder(String uri) {
            this._uri = uri;
        }

        public MailBodyBuilder withLanguage(String lang) {
            this._lang = lang;
            return this;
        }

        public MailBodyBuilder withTitle(Object title) {
            this._title = title;
            return this;
        }

        public MailBodyBuilder withHint(I18nizableText hintMessage) {
            this._hintMessage = hintMessage;
            return this;
        }

        public MailBodyBuilder withView(String viewName) {
            this._viewName = viewName;
            return this;
        }

        public MailBodyBuilder withMessage(Object message) {
            this._messages = List.of(message);
            return this;
        }

        public MailBodyBuilder addMessage(Object message) {
            if (this._messages == null) {
                this._messages = new ArrayList<Object>();
            }
            this._messages.add(message);
            return this;
        }

        public MailBodyBuilder withContents(Set<Content> contents) {
            this._contents = contents;
            return this;
        }

        public MailBodyBuilder addContent(Content content) {
            if (this._contents == null) {
                this._contents = new HashSet<Content>();
            }
            this._contents.add(content);
            return this;
        }

        public MailBodyBuilder withLink(String linkUrl, I18nizableText linkText) {
            this._linkText = linkText;
            this._linkUrl = linkUrl;
            return this;
        }

        public MailBodyBuilder withFooterLink(String linkUrl, I18nizableText linkText) {
            return this.withFooterLink(linkUrl, linkText, null, null);
        }

        public MailBodyBuilder withFooterLink(String linkUrl, I18nizableText linkText, String imgPluginName, String imgPath) {
            this._footerLinkText = linkText;
            this._footerLinkUrl = linkUrl;
            this._footerImgPluginName = imgPluginName;
            this._footerImgPath = imgPath;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String build() throws IOException {
            String string;
            Source src = null;
            Request request = ContextHelper.getRequest((Context)_context);
            try {
                request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, this.toJson());
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("lang", this._lang);
                src = _srcResolver.resolveURI(this._uri, null, parameters);
                InputStreamReader reader = new InputStreamReader(src.getInputStream(), "UTF-8");
                string = IOUtils.toString((Reader)reader);
            }
            catch (Throwable throwable) {
                _srcResolver.release(src);
                throw throwable;
            }
            _srcResolver.release(src);
            return string;
        }

        public Map<String, Object> toJson() {
            HashMap<String, Object> json = new HashMap<String, Object>();
            json.put("title", this._title);
            if (this._hintMessage != null) {
                json.put("hint", this._hintMessage);
            }
            if (this._messages != null && !this._messages.isEmpty()) {
                json.put("message", this._messages);
            }
            if (StringUtils.isNotEmpty((String)this._linkUrl)) {
                json.put("link", Map.of("url", this._linkUrl, "text", this._linkText));
            }
            if (this._contents != null && !this._contents.isEmpty()) {
                json.put("content", this._contents.stream().map(this::_content2json).toList());
            }
            json.put("footer", this._footer2json());
            return json;
        }

        private Map<String, Object> _footer2json() {
            HashMap<String, Object> footer2json = new HashMap<String, Object>();
            if (this._footerLinkUrl != null && this._footerLinkText != null) {
                HashMap<String, Object> link2json = new HashMap<String, Object>();
                link2json.put("text", this._footerLinkText);
                link2json.put("url", this._footerLinkUrl);
                if (this._footerImgPath != null && this._footerImgPluginName != null) {
                    link2json.put("imgPluginName", this._footerImgPluginName);
                    link2json.put("imgPath", this._footerImgPath);
                }
                footer2json.put("link", link2json);
            }
            return footer2json;
        }

        private Map<String, Object> _content2json(Content content) {
            WebContent webContent;
            String pageId;
            HashMap<String, Object> content2json = new HashMap<String, Object>();
            View view = _contentTypesHelper.getView(this._viewName, content);
            if (view != null) {
                content2json.put("id", content.getId());
                content2json.put("values", content.dataToJSON((ViewItemAccessor)view, DataContext.newInstance().withEmptyValues(false).withLocale(new Locale(this._lang))));
            }
            if (content instanceof WebContent && (pageId = (String)(webContent = (WebContent)content).getReferencingPages().stream().findFirst().map(AmetysObject::getId).orElse(null)) != null) {
                content2json.put("pageId", pageId);
            }
            return content2json;
        }
    }
}

