/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.type;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.group.GroupHelper;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.SubscriptionException;
import org.ametys.plugins.pagesubscription.context.SubscriptionContext;
import org.ametys.plugins.pagesubscription.type.SubscriptionType;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.query.SortCriteria;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.BooleanExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.MetadataExpression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.repository.query.expression.UserExpression;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractSubscriptionType<C extends SubscriptionContext, T>
extends AbstractLogEnabled
implements SubscriptionType<C, T>,
Configurable,
Serviceable {
    private static final String __NOTIFICATION_USER_PREF_CONTEXT_PREFIX = "/page-subscription/notifications/";
    private static final String __NOTIFICATION_USER_PREF_LAST_UPDATE = "lastUpdate";
    private static final String __ROOT_NODE_NAME = "ametys:subscriptions";
    private static final String __PLUGIN_NODE_NAME = "subscriptions";
    private static final String __SUBSCRIPTION_NAME_PREFIX = "ametys-subscription_";
    protected AmetysObjectResolver _resolver;
    protected GroupManager _groupManager;
    protected UserHelper _userHelper;
    private UserManager _userManager;
    protected GroupHelper _groupHelper;
    protected UserPreferencesManager _userPrefManager;
    protected JSONUtils _jsonUtils;
    private String _id;

    public void service(ServiceManager manager) throws ServiceException {
        this._groupManager = (GroupManager)manager.lookup(GroupManager.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._groupHelper = (GroupHelper)manager.lookup(GroupHelper.ROLE);
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        this._userPrefManager = (UserPreferencesManager)manager.lookup(UserPreferencesManager.ROLE);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._id = configuration.getAttribute("id");
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public Subscription subscribe(Site site, UserIdentity user, FrequencyHelper.Frequency frequency, List<BroadcastChannelHelper.BroadcastChannel> broadcastChannels, C context) throws Exception {
        boolean alreadySubscribe = this.getUserSubscriptions(site, user, false, context).stream().filter(s -> s.getSubscribersGroup().isEmpty() || s.isForced()).findAny().isPresent();
        if (alreadySubscribe) {
            throw new SubscriptionException("The user " + user + " try to subscribe whereas the subscription already exists", SubscriptionException.Type.ALREADY_EXIST);
        }
        Subscription subscription = this._addSubscription(site, (SubscriptionType)this, user, frequency, broadcastChannels, ZonedDateTime.now());
        this.setAdditionalData(subscription, context);
        subscription.saveChanges();
        return subscription;
    }

    @Override
    public Subscription forceSubscription(Site site, UserIdentity user, FrequencyHelper.Frequency frequency, SubscriptionType.FrequencyTiming forcedTiming, List<BroadcastChannelHelper.BroadcastChannel> broadcastChannels, C context) throws Exception {
        boolean alreadySubscribe = this.getUserSubscriptions(site, user, true, context).stream().filter(s -> s.getSubscribersGroup().isEmpty()).findAny().isPresent();
        if (alreadySubscribe) {
            throw new SubscriptionException("The user " + user + " try to subscribe whereas the subscription already exists", SubscriptionException.Type.ALREADY_EXIST);
        }
        Subscription subscription = this._forceSubscription(site, (SubscriptionType)this, user, frequency, forcedTiming, broadcastChannels, ZonedDateTime.now());
        this.setAdditionalData(subscription, context);
        subscription.saveChanges();
        return subscription;
    }

    @Override
    public Subscription subscribe(Site site, GroupIdentity group, FrequencyHelper.Frequency frequency, List<BroadcastChannelHelper.BroadcastChannel> broadcastChannels, C context) throws Exception {
        boolean alreadySubscribe;
        boolean bl = alreadySubscribe = !this.getGroupsSubscriptions(site, Set.of(group), false, context).isEmpty();
        if (alreadySubscribe) {
            throw new SubscriptionException("The group " + group + " try to subscribe whereas the subscription already exists", SubscriptionException.Type.ALREADY_EXIST);
        }
        Subscription subscription = this._addSubscription(site, (SubscriptionType)this, group, frequency, broadcastChannels, ZonedDateTime.now());
        this.setAdditionalData(subscription, context);
        subscription.saveChanges();
        return subscription;
    }

    @Override
    public Subscription forceSubscription(Site site, GroupIdentity group, FrequencyHelper.Frequency frequency, SubscriptionType.FrequencyTiming forcedTiming, List<BroadcastChannelHelper.BroadcastChannel> broadcastChannels, C context) throws Exception {
        boolean alreadySubscribe;
        boolean bl = alreadySubscribe = !this.getGroupsSubscriptions(site, Set.of(group), true, context).isEmpty();
        if (alreadySubscribe) {
            throw new SubscriptionException("The group " + group + " try to subscribe whereas the subscription already exists", SubscriptionException.Type.ALREADY_EXIST);
        }
        Subscription subscription = this._forceSubscription(site, (SubscriptionType)this, group, frequency, forcedTiming, broadcastChannels, ZonedDateTime.now());
        this.setAdditionalData(subscription, context);
        subscription.saveChanges();
        return subscription;
    }

    protected void setAdditionalData(Subscription subscription, C context) {
    }

    @Override
    public Map<String, Object> subscriptionToJSON(Subscription subscription) {
        Optional<GroupIdentity> subscribersGroup;
        Optional<UserIdentity> subscriber;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", subscription.getId());
        result.put("frequency", this._frequencyToJson(subscription));
        result.put("broadcastChannel", this._channelsToJson(subscription));
        if (subscription.isForced()) {
            result.put("isForced", subscription.isForced());
            SubscriptionType.FrequencyTiming timing = subscription.getForceFrequencyTiming();
            result.put("forcedDay", timing.day());
            result.put("forcedHour", timing.time());
        }
        if ((subscriber = subscription.getSubscriber()).isPresent()) {
            result.put("subscriber", this._userHelper.user2json(subscriber.get()));
        }
        if ((subscribersGroup = subscription.getSubscribersGroup()).isPresent()) {
            result.put("group", this._groupHelper.group2JSON(subscribersGroup.get(), false));
        }
        return result;
    }

    protected List<Map<String, Object>> _channelsToJson(Subscription subscription) {
        return subscription.getBroadcastChannels().stream().map(c -> Map.of("name", c.name(), "label", BroadcastChannelHelper.getLabel(c))).toList();
    }

    protected Map<String, Object> _frequencyToJson(Subscription subscription) {
        FrequencyHelper.Frequency frequency = subscription.getFrequency();
        HashMap<String, Object> frequency2json = new HashMap<String, Object>();
        frequency2json.put("name", frequency.name());
        frequency2json.put("label", FrequencyHelper.getLabel(frequency));
        SubscriptionType.FrequencyTiming timing = subscription.getForceFrequencyTiming();
        frequency2json.put("smartLabel", FrequencyHelper.getSmartLabel(frequency, timing));
        frequency2json.put("fullLabel", FrequencyHelper.getFullLabel(frequency, subscription.getBroadcastChannels(), timing));
        return frequency2json;
    }

    @Override
    public void saxSubscription(ContentHandler contentHandler, Subscription subscription) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", subscription.getId());
        if (subscription.isForced()) {
            attrs.addCDATAAttribute("isForced", String.valueOf(subscription.isForced()));
            SubscriptionType.FrequencyTiming timing = subscription.getForceFrequencyTiming();
            attrs.addCDATAAttribute("forcedDay", String.valueOf(timing.day()));
            attrs.addCDATAAttribute("forcedHour", timing.time());
        }
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"subscription", (Attributes)attrs);
        this._saxFrequency(contentHandler, subscription);
        this._saxBroadcastChannel(contentHandler, subscription.getBroadcastChannels());
        this._saxSubscriber(contentHandler, subscription);
        this._saxSubscribersGroup(contentHandler, subscription);
        this._saxAdditionalData(contentHandler, subscription);
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"subscription");
    }

    protected void _saxAdditionalData(ContentHandler contentHandler, Subscription subscription) throws SAXException {
    }

    protected void _saxFrequency(ContentHandler contentHandler, Subscription subscription) throws SAXException {
        FrequencyHelper.Frequency frequency = subscription.getFrequency();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("name", frequency.name());
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"frequency", (Attributes)attrs);
        SubscriptionType.FrequencyTiming timing = subscription.getForceFrequencyTiming();
        FrequencyHelper.getLabel(frequency).toSAX(contentHandler, "label");
        FrequencyHelper.getSmartLabel(frequency, timing).toSAX(contentHandler, "smartLabel");
        FrequencyHelper.getFullLabel(frequency, subscription.getBroadcastChannels(), timing).toSAX(contentHandler, "fullLabel");
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"frequency");
    }

    protected void _saxBroadcastChannel(ContentHandler contentHandler, List<BroadcastChannelHelper.BroadcastChannel> channels) throws SAXException {
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"channels");
        for (BroadcastChannelHelper.BroadcastChannel channel : channels) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("name", channel.name());
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"channel", (Attributes)attrs);
            BroadcastChannelHelper.getLabel(channel).toSAX(contentHandler);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"channel");
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"channels");
    }

    protected void _saxSubscriber(ContentHandler contentHandler, Subscription subscription) throws SAXException {
        Optional<UserIdentity> subscriber = subscription.getSubscriber();
        if (subscriber.isPresent()) {
            this._userHelper.saxUserIdentity(subscriber.get(), contentHandler, "subscriber");
        }
    }

    protected void _saxSubscribersGroup(ContentHandler contentHandler, Subscription subscription) throws SAXException {
        Optional<GroupIdentity> subscribersGroup = subscription.getSubscribersGroup();
        if (subscribersGroup.isPresent()) {
            this._groupHelper.saxGroupIdentity(subscribersGroup.get(), contentHandler, "group");
        }
    }

    @Override
    public void editSubscription(Subscription subscription, FrequencyHelper.Frequency frequency, List<BroadcastChannelHelper.BroadcastChannel> broadcastChannels, C context) throws Exception {
        this._editSubscription(subscription, frequency, broadcastChannels);
        subscription.saveChanges();
    }

    @Override
    public void editForceSubscription(Subscription subscription, FrequencyHelper.Frequency frequency, List<BroadcastChannelHelper.BroadcastChannel> broadcastChannels, SubscriptionType.FrequencyTiming forcedTiming, C context) throws Exception {
        this._editSubscription(subscription, frequency, broadcastChannels);
        subscription.setValue("isForced", true);
        subscription.setValue("forcedDay", forcedTiming.day(), "long");
        subscription.setValue("forcedHour", forcedTiming.time(), "string");
        subscription.saveChanges();
    }

    private void _editSubscription(Subscription subscription, FrequencyHelper.Frequency frequency, List<BroadcastChannelHelper.BroadcastChannel> broadcastChannels) {
        subscription.setValue("frequency", frequency.name());
        String[] broadcastChannelNames = (String[])broadcastChannels.stream().map(Enum::name).toArray(String[]::new);
        subscription.setValue("broadcastChannel", broadcastChannelNames);
    }

    @Override
    public void unsubscribe(Site site, UserIdentity user, C context) throws Exception {
        for (Subscription subscription : this.getUserSubscriptions(site, user, false, context)) {
            this._removeUsersPreference(subscription);
            subscription.remove();
        }
        site.saveChanges();
    }

    @Override
    public void unsubscribe(Site site, GroupIdentity group, C context) throws Exception {
        for (Subscription subscription : this.getGroupsSubscriptions(site, Set.of(group), false, context)) {
            this.unsubscribe(subscription);
        }
    }

    @Override
    public void unsubscribe(Subscription subscription) throws Exception {
        Site site = subscription.getSite();
        this._removeUsersPreference(subscription);
        subscription.remove();
        site.saveChanges();
    }

    @Override
    public Set<UserIdentity> getSubscribers(Site site, FrequencyHelper.Frequency frequency, BroadcastChannelHelper.BroadcastChannel broadcastChannel, C context) {
        return this.getSubscriptions(site, frequency, broadcastChannel, context).stream().map(this::getSubscribers).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Set<UserIdentity> getSubscribers(Subscription subscription) {
        Group group;
        HashSet<UserIdentity> subscribers = new HashSet<UserIdentity>();
        Optional<UserIdentity> subscriber = subscription.getSubscriber();
        Optional<GroupIdentity> subscribersGroup = subscription.getSubscribersGroup();
        if (subscriber.isPresent()) {
            User user = this._userManager.getUser(subscriber.get());
            if (user != null) {
                subscribers.add(subscriber.get());
            }
        } else if (subscribersGroup.isPresent() && (group = this._groupManager.getGroup(subscribersGroup.get())) != null) {
            subscribers.addAll(group.getUsers());
        }
        return subscribers;
    }

    public List<Subscription> getSubscriptions(Site site, FrequencyHelper.Frequency frequency, BroadcastChannelHelper.BroadcastChannel broadcastChannel, C context) {
        Expression filterExpr = this.getSubscriptionsExpressions(frequency, broadcastChannel, null, null, false, false, context);
        String xpathQuery = this._getSubscriptionXPathQuery(site.getName(), filterExpr);
        AmetysObjectIterable subscriptions = this._resolver.query(xpathQuery);
        return subscriptions.stream().filter(this::isSubscriptionValid).toList();
    }

    public List<Subscription> getUserSubscriptions(Site site, UserIdentity user, boolean onlyForced, C context) {
        return this.getUserSubscriptions(site, null, null, user, onlyForced, context);
    }

    public List<Subscription> getUserSubscriptions(Site site, FrequencyHelper.Frequency frequency, BroadcastChannelHelper.BroadcastChannel broadcastChannel, UserIdentity user, boolean onlyForced, C context) {
        Set userGroups = this._groupManager.getUserGroups(user);
        Expression filterExpr = this.getSubscriptionsExpressions(null, null, user, userGroups, false, onlyForced, context);
        String xpathQuery = this._getSubscriptionXPathQuery(site.getName(), filterExpr);
        AmetysObjectIterable userSubscriptions = this._resolver.query(xpathQuery);
        HashMap subscriptionsByTarget = new HashMap();
        userSubscriptions.stream().filter(s -> s.getSubscribersGroup().isPresent()).filter(this::isSubscriptionValid).forEach(s -> {
            List list = subscriptionsByTarget.getOrDefault(s.getSubscriptionType().getTarget((Subscription)((Object)s)), new ArrayList());
            list.add(s);
            subscriptionsByTarget.put(s.getSubscriptionType().getTarget((Subscription)((Object)s)), list);
        });
        userSubscriptions.stream().filter(s -> s.getSubscriber().isPresent()).filter(this::isSubscriptionValid).filter(s -> !subscriptionsByTarget.containsKey(s.getSubscriptionType().getTarget((Subscription)((Object)s))) || s.isForced()).forEach(s -> {
            List list = subscriptionsByTarget.getOrDefault(s.getSubscriptionType().getTarget((Subscription)((Object)s)), new ArrayList());
            list.add(s);
            subscriptionsByTarget.put(s.getSubscriptionType().getTarget((Subscription)((Object)s)), list);
        });
        return subscriptionsByTarget.values().stream().flatMap(x -> x.stream()).filter(s -> frequency == null || s.getFrequency() == frequency).filter(s -> broadcastChannel == null || s.getBroadcastChannels().contains((Object)broadcastChannel)).sorted(Comparator.comparing(Subscription::getDate)).toList();
    }

    public List<Subscription> getGroupsSubscriptions(Site site, Set<GroupIdentity> groups, boolean onlyForced, C context) {
        return this.getGroupsSubscriptions(site, null, null, groups, onlyForced, context);
    }

    public List<Subscription> getGroupsSubscriptions(Site site, FrequencyHelper.Frequency frequency, BroadcastChannelHelper.BroadcastChannel broadcastChannel, Set<GroupIdentity> groups, boolean onlyForced, C context) {
        Expression filterExpr = this.getSubscriptionsExpressions(frequency, broadcastChannel, null, groups, true, onlyForced, context);
        String xpathQuery = this._getSubscriptionXPathQuery(site.getName(), filterExpr);
        return this._resolver.query(xpathQuery).stream().filter(Subscription.class::isInstance).map(Subscription.class::cast).filter(this::_isGroupExist).filter(this::isSubscriptionValid).toList();
    }

    private boolean _isGroupExist(Subscription subscription) {
        return subscription.getSubscribersGroup().map(g -> this._groupManager.getGroup(g) != null).orElse(false);
    }

    protected abstract boolean isSubscriptionValid(Subscription var1);

    protected Expression getSubscriptionsExpressions(FrequencyHelper.Frequency frequency, BroadcastChannelHelper.BroadcastChannel broadcastChannel, UserIdentity user, Set<GroupIdentity> userGroups, boolean onlyGroup, boolean onlyForced, C context) {
        Expression additionalExpr;
        ArrayList<Object> filterExprs = new ArrayList<Object>();
        filterExprs.add(new StringExpression("typeId", Expression.Operator.EQ, this._id));
        if (frequency != null) {
            filterExprs.add(new StringExpression("frequency", Expression.Operator.EQ, frequency.name()));
        }
        if (broadcastChannel != null) {
            filterExprs.add(new StringExpression("broadcastChannel", Expression.Operator.EQ, broadcastChannel.name()));
        }
        if (onlyGroup) {
            filterExprs.add(new MetadataExpression("group"));
            if (userGroups != null && !userGroups.isEmpty()) {
                StringExpression[] groupsExpr = (StringExpression[])userGroups.stream().map(GroupIdentity::groupIdentityToString).map(id -> new StringExpression("group", Expression.Operator.EQ, id)).toArray(StringExpression[]::new);
                filterExprs.add(new OrExpression((Expression[])groupsExpr));
            }
        } else if (user != null || userGroups != null && !userGroups.isEmpty()) {
            ArrayList<UserExpression> userExprs = new ArrayList<UserExpression>();
            if (user != null) {
                userExprs.add(new UserExpression("subscriber", Expression.Operator.EQ, user));
            }
            if (userGroups != null && !userGroups.isEmpty()) {
                userGroups.stream().map(GroupIdentity::groupIdentityToString).forEach(id -> userExprs.add((UserExpression)new StringExpression("group", Expression.Operator.EQ, id)));
            }
            filterExprs.add(new OrExpression(userExprs));
        }
        if (onlyGroup) {
            filterExprs.add(new MetadataExpression("group"));
        }
        if (onlyForced) {
            filterExprs.add(new BooleanExpression("isForced", true));
        }
        if (context != null && (additionalExpr = this.getAdditionalFilterExpression(context)) != null) {
            filterExprs.add(additionalExpr);
        }
        return new AndExpression(filterExprs.toArray(new Expression[filterExprs.size()]));
    }

    private String _getSubscriptionXPathQuery(String siteName, Expression filterExpression) {
        String predicats = null;
        if (filterExpression != null) {
            predicats = StringUtils.trimToNull((String)filterExpression.build());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("//element(" + siteName + ", ametys:site)");
        sb.append("//element(*, ametys:subscription)");
        if (predicats != null) {
            sb.append("[").append(predicats).append("]");
        }
        SortCriteria sort = new SortCriteria();
        sort.addCriterion("date", false, false);
        sb.append(" ").append(sort.build());
        return sb.toString();
    }

    protected abstract Expression getAdditionalFilterExpression(C var1);

    @Override
    public ZonedDateTime getLastReadDate(Subscription subscription, UserIdentity user) {
        try {
            String context = __NOTIFICATION_USER_PREF_CONTEXT_PREFIX + subscription.getSite().getName();
            Map<String, Object> userPreferences = this._getUserPreferences(context, user);
            String userPreferenceContextId = this.getUserPreferenceContextId(subscription);
            if (userPreferences.containsKey(userPreferenceContextId)) {
                return DateUtils.parseZonedDateTime((String)((String)userPreferences.get(userPreferenceContextId)));
            }
        }
        catch (UserPreferencesException e) {
            this.getLogger().warn("Unable to get last unread notifications date from user preferences", (Throwable)e);
        }
        return null;
    }

    @Override
    public void markAsRead(Subscription subscription, UserIdentity user) {
        try {
            String context = __NOTIFICATION_USER_PREF_CONTEXT_PREFIX + subscription.getSite().getName();
            Map<String, Object> userPreferences = this._getUserPreferences(context, user);
            userPreferences.put(this.getUserPreferenceContextId(subscription), DateUtils.zonedDateTimeToString((ZonedDateTime)ZonedDateTime.now()));
            this._userPrefManager.setUserPreferences(user, context, Map.of(), Map.of(__NOTIFICATION_USER_PREF_LAST_UPDATE, this._jsonUtils.convertObjectToJson(userPreferences)));
        }
        catch (UserPreferencesException e) {
            this.getLogger().warn("Unable to set last unread notifications date from user preferences", (Throwable)e);
        }
    }

    private void _removeUsersPreference(Subscription subscription) {
        for (UserIdentity subscriber : this.getSubscribers(subscription)) {
            try {
                String context = __NOTIFICATION_USER_PREF_CONTEXT_PREFIX + subscription.getSite().getName();
                Map<String, Object> userPreferences = this._getUserPreferences(context, subscriber);
                userPreferences.remove(this.getUserPreferenceContextId(subscription));
                this._userPrefManager.setUserPreferences(subscriber, context, Map.of(), Map.of(__NOTIFICATION_USER_PREF_LAST_UPDATE, this._jsonUtils.convertObjectToJson(userPreferences)));
            }
            catch (UserPreferencesException e) {
                this.getLogger().warn("Unable to remove user preferences", (Throwable)e);
            }
        }
    }

    private Map<String, Object> _getUserPreferences(String context, UserIdentity user) throws UserPreferencesException {
        String userPreferencesAsString = this._userPrefManager.getUserPreferenceAsString(user, context, Map.of(), __NOTIFICATION_USER_PREF_LAST_UPDATE);
        return StringUtils.isNotBlank((String)userPreferencesAsString) ? this._jsonUtils.convertJsonToMap(userPreferencesAsString) : new HashMap();
    }

    protected abstract String getUserPreferenceContextId(Subscription var1);

    protected ModifiableTraversableAmetysObject _getSiteRootNode(Site site) throws AmetysRepositoryException {
        try {
            return this._getOrCreateRootNode(site);
        }
        catch (AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the susbcriptions root node", (Throwable)e);
        }
    }

    private ModifiableTraversableAmetysObject _getOrCreateRootNode(Site site) throws AmetysRepositoryException {
        ModifiableTraversableAmetysObject pluginsNode = site.getRootPlugins();
        ModifiableTraversableAmetysObject pluginNode = (ModifiableTraversableAmetysObject)this._getOrCreateNode(pluginsNode, __PLUGIN_NODE_NAME, "ametys:unstructured");
        return (ModifiableTraversableAmetysObject)this._getOrCreateNode(pluginNode, __ROOT_NODE_NAME, "ametys:collection");
    }

    private AmetysObject _getOrCreateNode(ModifiableTraversableAmetysObject parentNode, String nodeName, String nodeType) throws AmetysRepositoryException {
        AmetysObject definitionsNode;
        if (parentNode.hasChild(nodeName)) {
            definitionsNode = parentNode.getChild(nodeName);
        } else {
            definitionsNode = parentNode.createChild(nodeName, nodeType);
            parentNode.saveChanges();
        }
        return definitionsNode;
    }

    protected Subscription _addSubscription(Site site, SubscriptionType type, UserIdentity user, FrequencyHelper.Frequency frequency, List<BroadcastChannelHelper.BroadcastChannel> broadcastChannels, ZonedDateTime date) {
        ModifiableTraversableAmetysObject siteRootNode = this._getSiteRootNode(site);
        Subscription subscription = this._addSubscription(siteRootNode, type, frequency, broadcastChannels, date);
        subscription.setValue("subscriber", user, "user");
        siteRootNode.saveChanges();
        return subscription;
    }

    protected Subscription _forceSubscription(Site site, SubscriptionType type, UserIdentity user, FrequencyHelper.Frequency frequency, SubscriptionType.FrequencyTiming forcedTiming, List<BroadcastChannelHelper.BroadcastChannel> broadcastChannels, ZonedDateTime date) {
        Subscription subscription = this._addSubscription(site, type, user, frequency, broadcastChannels, date);
        this._forceSubscription(subscription, forcedTiming);
        return subscription;
    }

    protected Subscription _addSubscription(Site site, SubscriptionType type, GroupIdentity group, FrequencyHelper.Frequency frequency, List<BroadcastChannelHelper.BroadcastChannel> broadcastChannels, ZonedDateTime date) {
        ModifiableTraversableAmetysObject siteRootNode = this._getSiteRootNode(site);
        Subscription subscription = this._addSubscription(siteRootNode, type, frequency, broadcastChannels, date);
        subscription.setValue("group", GroupIdentity.groupIdentityToString((GroupIdentity)group), "string");
        siteRootNode.saveChanges();
        return subscription;
    }

    protected Subscription _forceSubscription(Site site, SubscriptionType type, GroupIdentity group, FrequencyHelper.Frequency frequency, SubscriptionType.FrequencyTiming forcedTiming, List<BroadcastChannelHelper.BroadcastChannel> broadcastChannels, ZonedDateTime date) {
        Subscription subscription = this._addSubscription(site, type, group, frequency, broadcastChannels, date);
        this._forceSubscription(subscription, forcedTiming);
        return subscription;
    }

    private Subscription _addSubscription(ModifiableTraversableAmetysObject siteRootNode, SubscriptionType type, FrequencyHelper.Frequency frequency, List<BroadcastChannelHelper.BroadcastChannel> broadcastChannels, ZonedDateTime date) {
        String subscriptionName = __SUBSCRIPTION_NAME_PREFIX + UUID.randomUUID().toString();
        Subscription subscription = (Subscription)siteRootNode.createChild(subscriptionName, "ametys:subscription");
        subscription.setValue("typeId", type.getId(), "string");
        subscription.setValue("date", date, "datetime");
        subscription.setValue("frequency", frequency.name(), "string");
        String[] broadcastChannelNames = (String[])broadcastChannels.stream().map(Enum::name).toArray(String[]::new);
        subscription.setValue("broadcastChannel", broadcastChannelNames, "string");
        return subscription;
    }

    private void _forceSubscription(Subscription subscription, SubscriptionType.FrequencyTiming forcedTiming) {
        subscription.setValue("isForced", true, "boolean");
        subscription.setValue("forcedDay", forcedTiming.day(), "long");
        subscription.setValue("forcedHour", forcedTiming.time(), "string");
        subscription.saveChanges();
    }
}

