<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2014 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
   
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:docbook="http://docbook.org/ns/docbook" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:math="http://exslt.org/math" 
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:subscribe="org.ametys.plugins.pagesubscription.page.helpers.PageSubscriptionXSLTHelper"
    exclude-result-prefixes="docbook"
    extension-element-prefixes="math ametys">

   	<xsl:import href="plugin:web://stylesheets/helper/common.xsl"/>
    
    <xsl:variable name="uniqueId" select="concat('page_subscribe_', substring-after(math:random(), '.'))"/>
    <xsl:variable name="page-subscribe-page-id" select="ametys:pageId()"/>
   
    <xsl:template name="page-subscribe-form-get-url">
        <xsl:value-of select="concat(ametys:siteUriPrefix(), '/', ametys:lang(), '/_plugins/page-subscription/page/subscribe')"/>
    </xsl:template>   
    
   	<xsl:template name="page-subscription">
        <xsl:param name="handle-link-content"><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_TITLE" i18n:catalogue="plugin.page-subscription"/></xsl:param>
        <xsl:param name="subscribe-link-content"><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_POPUP_SUBSCRIBE_TITLE" i18n:catalogue="plugin.page-subscription"/></xsl:param>
        <xsl:param name="unsubscribe-link-content"><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_POPUP_UNSUBSCRIBE_TITLE" i18n:catalogue="plugin.page-subscription"/></xsl:param>
        <xsl:param name="handle-dialog-title"><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_TITLE" i18n:catalogue="plugin.page-subscription"/></xsl:param>
        <xsl:param name="subscribe-dialog-title"><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_POPUP_SUBSCRIBE_TITLE" i18n:catalogue="plugin.page-subscription"/></xsl:param>
        <xsl:param name="unsubscribe-dialog-title"><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_POPUP_UNSUBSCRIBE_TITLE" i18n:catalogue="plugin.page-subscription"/></xsl:param>
        <xsl:param name="subscribe-dialog-text">&lt;p&gt;<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_POPUP_HANDLE_SUBSCRIBE_DESC" i18n:catalogue="plugin.page-subscription"/>&lt;/p&gt;</xsl:param>
        <xsl:param name="unsubscribe-dialog-text">&lt;p&gt;<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_POPUP_HANDLE_UNSUBSCRIBE_DESC" i18n:catalogue="plugin.page-subscription"/>&lt;/p&gt;</xsl:param>
        <xsl:param name="subscribe-dialog-confirm">&lt;p&gt;<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_POPUP_SUBSCRIBE_DESC" i18n:catalogue="plugin.page-subscription"/>&lt;/p&gt;</xsl:param>
        <xsl:param name="unsubscribe-dialog-confirm">&lt;p&gt;<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_POPUP_UNSUBSCRIBE_DESC" i18n:catalogue="plugin.page-subscription"/>&lt;/p&gt;</xsl:param>
        <xsl:param name="subscribe-action-text"><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_RADIO_SUBSCRIBE" i18n:catalogue="plugin.page-subscription"/></xsl:param>
        <xsl:param name="unsubscribe-action-text"><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_RADIO_UNSUBSCRIBE" i18n:catalogue="plugin.page-subscription"/></xsl:param>
        <xsl:param name="subscribe-success-title"><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_SUBSCRIBE_OK_TITLE" i18n:catalogue="plugin.page-subscription"/></xsl:param>
        <xsl:param name="unsubscribe-success-title"><i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_UNSUBSCRIBE_OK_TITLE" i18n:catalogue="plugin.page-subscription"/></xsl:param>
        <xsl:param name="subscribe-success-message">&lt;p&gt;<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_SUBSCRIBE_OK" i18n:catalogue="plugin.page-subscription"/>&lt;/p&gt;</xsl:param>
        <xsl:param name="unsubscribe-success-message">&lt;p&gt;<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_UNSUBSCRIBE_OK" i18n:catalogue="plugin.page-subscription"/>&lt;/p&gt;</xsl:param>
   	   
        <xsl:choose>
   	        <xsl:when test="ametys:isCacheable()">
   	            <xsl:call-template name="page-subscription-form-cacheable">
                    <xsl:with-param name="handle-link-content" select="$handle-link-content"/>
                    <xsl:with-param name="handle-dialog-title" select="$handle-dialog-title"/>
                    <xsl:with-param name="subscribe-action-text" select="$subscribe-action-text"/>
                    <xsl:with-param name="unsubscribe-action-text" select="$unsubscribe-action-text"/>
                    <xsl:with-param name="subscribe-dialog-text" select="$subscribe-dialog-text"/>
                    <xsl:with-param name="unsubscribe-dialog-text" select="$unsubscribe-dialog-text"/>
                </xsl:call-template>
   	        </xsl:when>
   	        <xsl:otherwise>
   	            <xsl:call-template name="page-subscription-form-non-cacheable">
                    <xsl:with-param name="handle-link-content" select="$handle-link-content"/>
                    <xsl:with-param name="subscribe-link-content" select="$subscribe-link-content"/>
                    <xsl:with-param name="unsubscribe-link-content" select="$unsubscribe-link-content"/>
                    <xsl:with-param name="subscribe-dialog-title" select="$subscribe-dialog-title"/>
                    <xsl:with-param name="unsubscribe-dialog-title" select="$unsubscribe-dialog-title"/>
                    <xsl:with-param name="subscribe-dialog-confirm" select="$subscribe-dialog-confirm"/>
                    <xsl:with-param name="unsubscribe-dialog-confirm" select="$unsubscribe-dialog-confirm"/>
                    <xsl:with-param name="subscribe-action-text" select="$subscribe-action-text"/>
                    <xsl:with-param name="unsubscribe-action-text" select="$unsubscribe-action-text"/>
                </xsl:call-template>
   	        </xsl:otherwise>
   	    </xsl:choose>
        
        <xsl:call-template name="page-subscribe-success-message-script">
            <xsl:with-param name="subscribe-success-title" select="$subscribe-success-title"/>
            <xsl:with-param name="unsubscribe-success-title" select="$unsubscribe-success-title"/>
            <xsl:with-param name="subscribe-success-message" select="$subscribe-success-message"/>
            <xsl:with-param name="unsubscribe-success-message" select="$unsubscribe-success-message"/>
        </xsl:call-template>
   	</xsl:template>
   	
    <!-- +
         | This template is called when the page is non cacheable.
         | If JavaScript is activated, display a "Handle subscription" link
         | If not, the form to subscribe or unsubscribe is displayed.
         + -->
   	<xsl:template name="page-subscription-form-cacheable">
        <xsl:param name="handle-link-content"/>
        <xsl:param name="handle-dialog-title"/>
        <xsl:param name="subscribe-action-text"/>
        <xsl:param name="unsubscribe-action-text"/>
        <xsl:param name="subscribe-dialog-text"/>
        <xsl:param name="unsubscribe-dialog-text"/>
        
   	    <xsl:call-template name="page-handle-subscribe-form-cacheable">
            <xsl:with-param name="handle-link-content" select="$handle-link-content"/>
            <xsl:with-param name="handle-dialog-title" select="$handle-link-content"/>
            <xsl:with-param name="subscribe-action-text" select="$subscribe-action-text"/>
            <xsl:with-param name="unsubscribe-action-text" select="$unsubscribe-action-text"/>
            <xsl:with-param name="subscribe-dialog-text" select="$subscribe-dialog-text"/>
            <xsl:with-param name="unsubscribe-dialog-text" select="$unsubscribe-dialog-text"/>
        </xsl:call-template>
        
        <xsl:call-template name="page-subscribe-link-script-submit" />
        <xsl:call-template name="page-subscribe-form-script"/>
   	</xsl:template>
   	
    <!-- +
         | This template is called when the page is non cacheable.
         | If a user is currently connected and javascript is activated, display link to directly subscribe or unsubscribe
         | If not, the form to subscribe or unsubscribe is displayed.
         + -->
   	<xsl:template name="page-subscription-form-non-cacheable">
        <xsl:param name="handle-link-content"/>
        <xsl:param name="subscribe-link-content"/>
        <xsl:param name="unsubscribe-link-content"/>
        <xsl:param name="subscribe-dialog-title"/>
        <xsl:param name="unsubscribe-dialog-title"/>
        <xsl:param name="subscribe-dialog-confirm"/>
        <xsl:param name="unsubscribe-dialog-confirm"/>
        <xsl:param name="subscribe-action-text"/>
        <xsl:param name="unsubscribe-action-text"/>
        
        <xsl:call-template name="page-handle-subscribe-form">
            <xsl:with-param name="handle-link-content" select="$handle-link-content"/>
            <xsl:with-param name="subscribe-action-text" select="$subscribe-action-text"/>
            <xsl:with-param name="unsubscribe-action-text" select="$unsubscribe-action-text"/>
        </xsl:call-template>
        
   	    <xsl:variable name="foUser" select="ametys:user()"/>
   	    <xsl:variable name="email"><xsl:if test="$foUser"><xsl:value-of select="$foUser/user/email"/></xsl:if></xsl:variable>
        <xsl:if test="$email != ''">
            <xsl:call-template name="page-subscribe-link">
                <xsl:with-param name="isRegistered" select="subscribe:isPageSubscriber($email)"/>
                <xsl:with-param name="email" select="$email"/>
                <xsl:with-param name="subscribe-link-content" select="$subscribe-link-content"/>
                <xsl:with-param name="unsubscribe-link-content" select="$unsubscribe-link-content"/>
                <xsl:with-param name="subscribe-dialog-title" select="$subscribe-dialog-title"/>
                <xsl:with-param name="unsubscribe-dialog-title" select="$unsubscribe-dialog-title"/>
                <xsl:with-param name="subscribe-dialog-confirm" select="$subscribe-dialog-confirm"/>
                <xsl:with-param name="unsubscribe-dialog-confirm" select="$unsubscribe-dialog-confirm"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <!-- +
         | This template is used when a user is connected, his email is not empty and the page is not cacheable
         | Display a "Subscribe" or "Unsubscribe" link according if user is subscribed or not.
         + -->
    <xsl:template name="page-subscribe-link">
        <xsl:param name="subscribe-link-content"/>
        <xsl:param name="unsubscribe-link-content"/>
        <xsl:param name="subscribe-dialog-title"/>
        <xsl:param name="unsubscribe-dialog-title"/>
        <xsl:param name="subscribe-dialog-confirm"/>
        <xsl:param name="unsubscribe-dialog-confirm"/>
        <xsl:param name="email"/>
        <xsl:param name="isRegistered"/>
        
        <xsl:call-template name="page-subscribe-link-script-submit" />
        
	    <div id="page-subscribe-link-wrapper-{$uniqueId}" class="page-subscribe"></div>
    
        <script type="text/javascript">
             function page_subscribe_popup_<xsl:value-of select="$uniqueId"/>(mode, successCb)
             {
                var title = mode == 'subscribe' ? "<xsl:copy-of select="$subscribe-dialog-title"/>" : "<xsl:copy-of select="$unsubscribe-dialog-title"/>";
                $j("#page-" + mode + "-confirm-<xsl:value-of select="$uniqueId"/>").dialog({
                  resizable: false,
                  height: 'auto',
                  width: 'auto',
                  modal: true,
                  title: title,
                  buttons: {
                    <i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_VALIDATE" i18n:catalogue="plugin.page-subscription"/>: function() {
                        $j( this ).dialog( "close" );
                        page_subscribe_popup_submit_<xsl:value-of select="$uniqueId"/>(mode, '<xsl:value-of select="$email"/>', successCb);
                    },
                    <i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_CANCEL" i18n:catalogue="plugin.page-subscription"/>: function() {
                        $j( this ).dialog( "close" );
                    }
                  }
                });
             }
            
             function subscribe_<xsl:value-of select="$uniqueId"/>()
             {
                // Insert the "Subcribe" link
                $j("#page-subscribe-link-<xsl:value-of select="$uniqueId"/>").remove();
                $j("#page-subscribe-link-wrapper-<xsl:value-of select="$uniqueId"/>").append("&lt;p id=\"page-subscribe-link-<xsl:value-of select="$uniqueId"/>\"&gt;&lt;a class=\"page-subscribe-subscribe\" href=\"javascript: page_subscribe_popup_<xsl:value-of select="$uniqueId"/>('subscribe', unsubscribe_<xsl:value-of select="$uniqueId"/>)\"&gt;<xsl:copy-of select="$subscribe-link-content"/>&lt;/a&gt;&lt;/p&gt;")            
             }
             function unsubscribe_<xsl:value-of select="$uniqueId"/>()
             {
                // Insert the "Unsubcribe" link
                $j("#page-subscribe-link-<xsl:value-of select="$uniqueId"/>").remove();
                $j("#page-subscribe-link-wrapper-<xsl:value-of select="$uniqueId"/>").append("&lt;p id=\"page-subscribe-link-<xsl:value-of select="$uniqueId"/>\"&gt;&lt;a class=\"page-subscribe-unsubscribe\" href=\"javascript: page_subscribe_popup_<xsl:value-of select="$uniqueId"/>('unsubscribe', subscribe_<xsl:value-of select="$uniqueId"/>)\"&gt;<xsl:copy-of select="$unsubscribe-link-content"/>&lt;/a&gt;&lt;/p&gt;")            
             }
             
             // Confirm dialog box
             $j("#page-subscribe-link-wrapper-<xsl:value-of select="$uniqueId"/>").append("&lt;div style=\"display: none\" id=\"page-subscribe-confirm-<xsl:value-of select="$uniqueId"/>\"&gt;<xsl:copy-of select="$subscribe-dialog-confirm"/>&lt;/div&gt;");
             $j("#page-subscribe-link-wrapper-<xsl:value-of select="$uniqueId"/>").append("&lt;div style=\"display: none\" id=\"page-unsubscribe-confirm-<xsl:value-of select="$uniqueId"/>\"&gt;<xsl:copy-of select="$unsubscribe-dialog-confirm"/>&lt;/div&gt;");
                    
             // Hide the "Handle subscription" text
             $j("#page-subscribe-title-<xsl:value-of select="$uniqueId"/>").css('display', 'none');
             
             <xsl:choose>
                <xsl:when test="$isRegistered">
                    unsubscribe_<xsl:value-of select="$uniqueId"/>();
                </xsl:when>
                <xsl:otherwise>
                    subscribe_<xsl:value-of select="$uniqueId"/>();
                </xsl:otherwise>
             </xsl:choose>
        </script>
    </xsl:template>
    
    <!-- +
         | This template draws the subscribe/unsubscribe form when the page is non-cacheable.
         | If javascript is activated, the form will be hidden
         + -->
    <xsl:template name="page-handle-subscribe-form">  
        <xsl:param name="handle-link-content"/>
        <xsl:param name="subscribe-action-text"/>
        <xsl:param name="unsubscribe-action-text"/>
                
        <xsl:call-template name="page-subscribe-form-script"/>
        
        <div class="page-subscribe"> 
	        <p id="page-subscribe-title-{$uniqueId}"><xsl:copy-of select="$handle-link-content"/></p>
            
            <xsl:call-template name="page-subscribe-form">
                <xsl:with-param name="subscribe-action-text" select="$subscribe-action-text"/>
                <xsl:with-param name="unsubscribe-action-text" select="$unsubscribe-action-text"/>
            </xsl:call-template>
   
            <script type="text/javascript">
               $j("#page-subscribe-title-<xsl:value-of select="$uniqueId"/>").wrapInner("&lt;a class=\"page-subscribe-handle\"  href='javascript: page_subscribe_form_popup_<xsl:value-of select="$uniqueId"/>()'&gt;&lt;/a&gt;");
               // Hide the form
               $j("#page-subscribe-form-<xsl:value-of select="$uniqueId"/>").css('display', 'none');
               $j("#page-subscribe-submit-<xsl:value-of select="$uniqueId"/>").css('display', 'none');
            </script>
       </div>         
    </xsl:template>
    
    <!-- +
         | This template draws the subscribe/unsubscribe form when the page is cacheable.
         | If javascript is activated, the form will be hidden
         + -->
    <xsl:template name="page-handle-subscribe-form-cacheable"> 
        <xsl:param name="handle-link-content"/>
        <xsl:param name="handle-dialog-title"/>
        <xsl:param name="subscribe-action-text"/>
        <xsl:param name="unsubscribe-action-text"/>
        <xsl:param name="subscribe-dialog-text"/>
        <xsl:param name="unsubscribe-dialog-text"/>
                      
        <div class="page-subscribe"> 
            <script type="text/javascript">
                function page_subscribe_get_info_user_<xsl:value-of select="$uniqueId"/>()
                {       
                    // send it in ajax
                    var data = {
                        "page-id": "<xsl:value-of select="$page-subscribe-page-id"/>",
                        "siteName": "<xsl:value-of select="$site"/>"
                    };
            
                    function result(data)
                    {
                        var users = $j('user', data);
                        if (users.attr("isLogged") == "true")
                        {
                            if (users.attr("isRegistered") == "false")
                            {
                                page_subscribe_popup_subscribe_<xsl:value-of select="$uniqueId"/>('subscribe', users.text());
                            }
                            else
                            {
                                page_subscribe_popup_subscribe_<xsl:value-of select="$uniqueId"/>('unsubscribe', users.text());
                            }
                        }
                        else
                        {
                            page_subscribe_form_popup_<xsl:value-of select="$uniqueId"/>('subscribe');
                        }
                    }
                    
                    function handleError(jqXHR, textStatus, errorThrown)
                    {
                        alert("<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_ERROR_AJAX" i18n:catalogue="plugin.page-subscription"/>");
                    }
            
                    $j.ajax({
                        url: "<xsl:value-of select="$uri-prefix"/>/plugins/page-subscription/info-user",
                        data: data,
                        type: 'post',
                        success: result,
                        error: handleError
                    });                     
                }
                
                function page_subscribe_popup_subscribe_<xsl:value-of select="$uniqueId"/>(mode, email)
                {
                    $j("#page-subscribe-confirm-" + mode + "-<xsl:value-of select="$uniqueId"/>").dialog({
                      resizable: false,
                      height: 'auto',
                      width: 'auto',
                      modal: true,
                      title: "<xsl:copy-of select="$handle-dialog-title"/>",
                      buttons: {
                        <i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_VALIDATE" i18n:catalogue="plugin.page-subscription"/>: function() {
                            page_subscribe_popup_submit_<xsl:value-of select="$uniqueId"/>(mode, email);
                        },
                        <i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_CANCEL" i18n:catalogue="plugin.page-subscription"/>: function() {
                          $j( this ).dialog( "close" );
                        }
                      }
                    });
                }
            </script>
            
            <p id="page-subscribe-title-{$uniqueId}"><xsl:copy-of select="$handle-link-content"/></p>         
            
            <xsl:call-template name="page-subscribe-form">
                <xsl:with-param name="subscribe-action-text" select="$subscribe-action-text"/>
                <xsl:with-param name="unsubscribe-action-text" select="$unsubscribe-action-text"/>
            </xsl:call-template>
            
            <div id="page-subscribe-confirm-wrapper-{$uniqueId}"/>
            
            <script type="text/javascript">
             $j("#page-subscribe-title-<xsl:value-of select="$uniqueId"/>").wrapInner("&lt;a class=\"page-subscribe-handle\" href=\"javascript: page_subscribe_get_info_user_<xsl:value-of select="$uniqueId"/>()\"&gt;&lt;/a&gt;")
                // Hide the form
                $j("#page-subscribe-form-<xsl:value-of select="$uniqueId"/>").css('display', 'none');
                $j("#page-subscribe-submit-<xsl:value-of select="$uniqueId"/>").css('display', 'none');
                
                 // Confirm messages 
                $j('#page-subscribe-confirm-wrapper-<xsl:value-of select="$uniqueId"/>').append("&lt;div id=\"page-subscribe-confirm-subscribe-<xsl:value-of select="$uniqueId"/>\" style=\"display: none\"&gt;<xsl:copy-of select="$subscribe-dialog-text"/>&lt;/div&gt;");
                $j('#page-subscribe-confirm-wrapper-<xsl:value-of select="$uniqueId"/>').append("&lt;div id=\"page-subscribe-confirm-unsubscribe-<xsl:value-of select="$uniqueId"/>\" style=\"display: none\"&gt;<xsl:copy-of select="$unsubscribe-dialog-text"/>&lt;/div&gt;");
            </script>
       </div>         
    </xsl:template>
    
    <xsl:template name="page-subscribe-form">
        <xsl:param name="subscribe-action-text"/>
        <xsl:param name="unsubscribe-action-text"/>
        
        <xsl:variable name="page-subscribe-form-url"><xsl:call-template name="page-subscribe-form-get-url"/></xsl:variable>    
    
        <form id="page-subscribe-form-{$uniqueId}" action="{$page-subscribe-form-url}" method="post">
            <div id="page-subscribe-form-dialog-{$uniqueId}" class="page-subscribe-form">
               <input type="hidden" name="page-id" id="page-subscribe-{$uniqueId}-id" value="{$page-subscribe-page-id}"/>                    
            
               <xsl:call-template name="page-subscribe-form-field-mail"/>
               <xsl:call-template name="page-subscribe-form-field-action">
                    <xsl:with-param name="subscribe-action-text" select="$subscribe-action-text"/>
                    <xsl:with-param name="unsubscribe-action-text" select="$unsubscribe-action-text"/>
               </xsl:call-template>  
               <xsl:call-template name="page-subscribe-form-field-submit"/>                     
            </div>
        </form>
    </xsl:template>
    
    <xsl:template name="page-subscribe-form-field-mail">
        <div class="field">
            <div class="label">
                <label for="page-subscribe-{$uniqueId}-email">
                    <i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_MAIL" i18n:catalogue="plugin.page-subscription"/>
                    <xsl:call-template name="page-subscribe-form-mandatorymarker"/>
                </label>
            </div>
            <div class="input">
                <input class="text" type="text" name="email" id="page-subscribe-{$uniqueId}-email"/>
            </div>
            <div class="field-end"></div>
        </div>
    </xsl:template>
    
    <xsl:template name="page-subscribe-form-field-action">
        <xsl:param name="subscribe-action-text"/>
        <xsl:param name="unsubscribe-action-text"/>
        
        <div class="field">
            <div class="input">
                <input type="radio" name="page-subscribe-action" id="page-subscribe-{$uniqueId}-action-subscribe" checked="checked" value="subscribe"/>
                <label for="page-subscribe-{$uniqueId}-action-subscribe">  
                    <xsl:copy-of select="$subscribe-action-text"/>
                </label>
            </div>
	        <div class="field-end"></div>        
        </div>
        <div class="field">
            <div class="input">
                <input type="radio" name="page-subscribe-action" id="page-subscribe-{$uniqueId}-action-unsubscribe" value="unsubscribe" />
                <label for="page-subscribe-{$uniqueId}-action-unsubscribe">
                    <xsl:copy-of select="$unsubscribe-action-text"/>
                </label>
            </div>
            <div class="field-end"></div>
        </div>    
    </xsl:template>
    
    <xsl:template name="page-subscribe-form-field-submit">
         <div id="page-subscribe-submit-{$uniqueId}">
             <xsl:call-template name="common-utils-input-submit">
                 <xsl:with-param name="i18nkey" select="'plugin.page-subscription:PLUGINS_PAGE_SUBSCRIBE_FORM_VALIDATE'" />                
             </xsl:call-template>
         </div>
    </xsl:template>
    
    <xsl:template name="page-subscribe-form-mandatorymarker">
        <span class="mandatory-marker">
            <i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD" i18n:catalogue="plugin.web"/>
        </span>
    </xsl:template> 
    
    <xsl:template name="page-subscribe-form-script">
         <script type="text/javascript">
             function page_subscribe_form_popup_<xsl:value-of select="$uniqueId"/>()
             {
                 $j("#page-subscribe-form-<xsl:value-of select="$uniqueId"/>").dialog({
                   resizable: false,
                   height: 'auto',
                   width: 'auto',
                   modal: true,
                   title: '<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_TITLE" i18n:catalogue="plugin.page-subscription"/>',
                   buttons: {
                     <i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_VALIDATE" i18n:catalogue="plugin.page-subscription"/>: function() {
                       page_subscribe_form_submit_<xsl:value-of select="$uniqueId"/>();
                     },
                     <i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_CANCEL" i18n:catalogue="plugin.page-subscription"/>: function() {
                       $j( this ).dialog( "close" );
                     }
                   }
                 });
                 
                 $j('#page-subscribe-<xsl:value-of select="$uniqueId"/>-email').val('');
             }
             
             function page_subscribe_form_submit_<xsl:value-of select="$uniqueId"/>()
             {             
                 var pageId =  $j('#page-subscribe-<xsl:value-of select="$uniqueId"/>-id');
                 var emailInput = $j('#page-subscribe-<xsl:value-of select="$uniqueId"/>-email');
                 var action = $j('input:radio[name="page-subscribe-action"]:checked');

                 var errors = false;
                 
                 if (!/^([a-z0-9._-]+@[a-z0-9.-]{2,}[.][a-z]{2,})?$/.test(emailInput.val()) || /^\s*$/.test(emailInput.val()))
                 {
                     errors = true;
                     emailInput.parentsUntil('.field').parent().addClass('error');
                 }
                 else
                 {
                     emailInput.parentsUntil('.field').parent().removeClass('error');
                 }

                 if (!errors)
                 {
                     // send it in ajax
                     var data = {
                         "page-id": pageId.val(),
                         "email": emailInput.val(),
                         "page-subscribe-action": action.val(),
                         "ajax": "true"
                     };

                     function result(data)
                     {
                         var s = "";
                         $j('errors error', data).each(function () { s += $j(this).text() + "\n"; });
                         if (s == "")
                         {
                             var errors = $j('error > error', data);
                             if (errors.length == 0)
                             {
                                 $j("#page-subscribe-form-<xsl:value-of select="$uniqueId"/>").dialog("close");
                                 show_success_message_<xsl:value-of select="$uniqueId"/>(action.val());                 
                             }
                             else
                             {
                                 var errorInfo = "";
                                 $j.each(errors, function(i) {
                                     errorInfo += "\n* " + $j(errors[i]).text();
                                 }); 
                                 alert("<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_ERROR_DESCRIPTION"  i18n:catalogue="plugin.page-subscription"/>" + errorInfo)
                             }
                         }
                         else
                         {
                             alert(s);
                         }
                     }
                     
                     function handleError(jqXHR, textStatus, errorThrown)
                     {
                         alert("<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_ERROR_AJAX" i18n:catalogue="plugin.page-subscription"/>");
                     }

                     $j.ajax({
                         url: "<xsl:value-of select="$uri-prefix"/>/plugins/page-subscription/subscribe",
                         data: data,
                         type: 'post',
                         success: result,
                         error: handleError
                     });                     
                 }

                 return false;
             }
         </script>
    </xsl:template>
    
    <xsl:template name="page-subscribe-link-script-submit">
        <script type="text/javascript">      
        function page_subscribe_popup_submit_<xsl:value-of select="$uniqueId"/>(action, email, successCb)
        {                    
            // send it in ajax
            var data = {
                "page-id": "<xsl:value-of select="$page-subscribe-page-id"/>",
                "email": email,
                "page-subscribe-action": action,
                "ajax": "true"
            };

            function result(data)
            {
                var s = "";
                $j('errors error', data).each(function () { s += $j(this).text() + "\n"; });
                if (s == "")
                {
                    var errors = $j('error > error', data);
                    if (errors.length == 0)
                    {
                        $j("#page-subscribe-confirm-<xsl:value-of select="$uniqueId"/>").dialog("close");
                        $j("#page-subscribe-confirm-" + action + "-<xsl:value-of select="$uniqueId"/>").dialog("close");
                        show_success_message_<xsl:value-of select="$uniqueId"/>(action);
                        if (successCb)
                        {
                            successCb();
                        }
                    }
                    else
                    {
                        var errorInfo = "";
                        $j.each(errors, function(i) {
                            errorInfo += "\n* " + $j(errors[i]).text();
                        }); 
                        alert("<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_ERROR_DESCRIPTION"  i18n:catalogue="plugin.page-subscription"/>" + errorInfo)
                    }
                }
                else
                {
                    alert(s);
                }
            }
            
            function handleError(jqXHR, textStatus, errorThrown)
            {
                alert("<i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_ERROR_AJAX" i18n:catalogue="plugin.page-subscription"/>");
            }

            $j.ajax({
                url: "<xsl:value-of select="$uri-prefix"/>/plugins/page-subscription/subscribe",
                data: data,
                type: 'post',
                success: result,
                error: handleError
            });                     

            return false;
        }
        </script>
     </xsl:template>
    
    <xsl:template name="page-subscribe-success-message-script">
        <xsl:param name="subscribe-success-title"/>
        <xsl:param name="unsubscribe-success-title"/>
        <xsl:param name="subscribe-success-message"/>
        <xsl:param name="unsubscribe-success-message"/>
        
        <div id="page-subscribe-message-wrapper-{$uniqueId}"></div>
        
        <script type="text/javascript">
            function show_success_message_<xsl:value-of select="$uniqueId"/>(mode)
            {
                $j("#page-subscribe-message-" + mode + "-<xsl:value-of select="$uniqueId"/>").dialog({
                  resizable: false,
                  height: 'auto',
                  width: 'auto',
                  modal: true,
                  title: mode == 'subscribe' ? "<xsl:copy-of select="$subscribe-success-title"/>" : "<xsl:copy-of select="$unsubscribe-success-title"/>",
                  buttons: {
                    <i18n:text i18n:key="PLUGINS_PAGE_SUBSCRIBE_FORM_OK" i18n:catalogue="plugin.page-subscription"/>: function() {
                      $j( this ).dialog( "close" );
                    }
                  }
                });
            }
            
            // Messages when subscribe or unscribe success
            $j('#page-subscribe-message-wrapper-<xsl:value-of select="$uniqueId"/>').append("&lt;div id=\"page-subscribe-message-subscribe-<xsl:value-of select="$uniqueId"/>\" style=\"display: none\"&gt;<xsl:copy-of select="$subscribe-success-message"/>&lt;/div&gt;");
            $j('#page-subscribe-message-wrapper-<xsl:value-of select="$uniqueId"/>').append("&lt;div id=\"page-subscribe-message-unsubscribe-<xsl:value-of select="$uniqueId"/>\" style=\"display: none\"&gt;<xsl:copy-of select="$unsubscribe-success-message"/>&lt;/div&gt;");
        </script>
    </xsl:template>
    
</xsl:stylesheet>