/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.jcr.Node;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.SubscriptionFactory;
import org.ametys.plugins.pagesubscription.type.SubscriptionType;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.data.ametysobject.ModifiableModelLessDataAwareAmetysObject;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.repository.jcr.SimpleAmetysObjectFactory;
import org.ametys.web.repository.site.Site;
import org.apache.commons.lang3.StringUtils;

public class Subscription
extends SimpleAmetysObject<SubscriptionFactory>
implements ModifiableModelLessDataAwareAmetysObject {
    public static final String ACTIVITY_ID_KEY = "id";
    public static final String ACTIVITY_NAME_KEY = "name";

    public Subscription(Node node, String parentPath, SubscriptionFactory factory) {
        super(node, parentPath, (SimpleAmetysObjectFactory)factory);
    }

    public ModifiableModelLessDataHolder getDataHolder() {
        JCRRepositoryData repositoryData = new JCRRepositoryData(this.getNode());
        return new DefaultModifiableModelLessDataHolder((ModelItemTypeExtensionPoint)((SubscriptionFactory)this._getFactory()).getElementTypesExtensionPoint(), (ModifiableRepositoryData)repositoryData);
    }

    public SubscriptionType getSubscriptionType() {
        return ((SubscriptionFactory)this._getFactory()).getSubscriptionType((String)this.getValue("typeId"));
    }

    public Optional<UserIdentity> getSubscriber() {
        return Optional.ofNullable((UserIdentity)this.getValue("subscriber"));
    }

    public Optional<GroupIdentity> getSubscribersGroup() {
        String value = (String)this.getValue("group");
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value}) ? Optional.of(GroupIdentity.stringToGroupIdentity((String)value)) : Optional.empty();
    }

    public List<BroadcastChannelHelper.BroadcastChannel> getBroadcastChannels() {
        return Stream.of((String[])this.getValue("broadcastChannel", new String[0])).map(c -> BroadcastChannelHelper.BroadcastChannel.valueOf(c)).toList();
    }

    public FrequencyHelper.Frequency getFrequency() {
        String frequencyType = (String)this.getValue("frequency");
        return FrequencyHelper.Frequency.valueOf(frequencyType);
    }

    public boolean isForced() {
        return (Boolean)this.getValue("isForced", false);
    }

    public SubscriptionType.FrequencyTiming getForceFrequencyTiming() {
        return new SubscriptionType.FrequencyTiming((Long)this.getValue("forcedDay"), (String)this.getValue("forcedHour"));
    }

    public ZonedDateTime getDate() {
        return (ZonedDateTime)this.getValue("date");
    }

    public Site getSite() {
        AmetysObject parent = this.getParent();
        while (!(parent instanceof Site)) {
            parent = parent.getParent();
        }
        return (Site)parent;
    }
}

