/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.page.notifier;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.plugins.pagesubscription.page.PageSubscriptionDAO;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.activities.AbstractPageActivityType;
import org.ametys.web.activities.notify.ActivityNotifier;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.jcr.DefaultPage;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPageSubscriptionNotifier
extends AbstractLogEnabled
implements ActivityNotifier,
Serviceable {
    protected AmetysObjectResolver _resolver;
    protected I18nUtils _i18nUtils;
    protected UserManager _userManager;
    protected PageSubscriptionDAO _subscriptionDAO;
    protected UserLanguagesManager _userLanguagesManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._subscriptionDAO = (PageSubscriptionDAO)((Object)manager.lookup(PageSubscriptionDAO.ROLE));
        this._userLanguagesManager = (UserLanguagesManager)manager.lookup(UserLanguagesManager.ROLE);
    }

    public Map<String, List<String>> getUsersToNotifyByLanguage(Activity activity) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        ActivityType activityType = activity.getActivityType();
        if (activityType instanceof AbstractPageActivityType) {
            User user = this._userManager.getUser(activity.getAuthor());
            String activityAuthorEmail = user != null ? user.getEmail() : null;
            String pageId = (String)activity.getValue("pageId");
            Page page = (Page)this._resolver.resolveById(pageId);
            if (page instanceof DefaultPage && this.isNotificationEnabled(page)) {
                ArrayList<String> emails = new ArrayList<String>();
                Set<String> subscribers = this._subscriptionDAO.getSubscribers(page);
                for (String subscriber : subscribers) {
                    if (!StringUtils.isNotBlank((CharSequence)subscriber) || subscriber.equals(activityAuthorEmail)) continue;
                    emails.add(subscriber);
                }
                result.put((String)StringUtils.defaultIfBlank((CharSequence)page.getSitemapName(), (CharSequence)this._userLanguagesManager.getDefaultLanguage()), emails);
            }
        }
        return result;
    }

    protected boolean isNotificationEnabled(Page page) {
        Site site = page.getSite();
        return (Boolean)site.getValue(this.getSiteParameterId(), true, (Object)false);
    }

    protected abstract String getSiteParameterId();

    public String getMailSubject(Activity activity, String language) {
        String pageId = (String)activity.getValue("pageId");
        Page page = (Page)this._resolver.resolveById(pageId);
        I18nizableText i18nSubject = this._getMailSubject(activity, page);
        return this._i18nUtils.translate((I18nizable)i18nSubject, language);
    }

    protected abstract I18nizableText _getMailSubject(Activity var1, Page var2);

    public String getMailTextBody(Activity activity, String language) {
        return null;
    }

    public String getMailHtmlBody(Activity activity, String language) {
        String pageId = (String)activity.getValue("pageId");
        Page page = (Page)this._resolver.resolveById(pageId);
        UserIdentity author = activity.getAuthor();
        User user = this._userManager.getUser(author);
        if (user != null) {
            try {
                return this._getMailHtmlBody(activity, language, page, user);
            }
            catch (Exception e) {
                this.getLogger().error("Can't get mail body for activity from event '{}' and type '{}'", new Object[]{activity.getEventType(), activity.getActivityType().getId(), e});
            }
        }
        return null;
    }

    protected abstract String _getMailHtmlBody(Activity var1, String var2, Page var3, User var4) throws IOException;

    protected String _getAbsolutePageUrl(Page page) {
        return page.getSite().getUrl() + "/" + page.getSitemapName() + "/" + page.getPathInSitemap() + ".html";
    }
}

