/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.schedulable.tag;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.tag.CMSTag;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.schedulable.tag.AbstractSendTagNotificationSummarySchedulable;
import org.ametys.plugins.pagesubscription.type.SubscriptionType;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.quartz.JobExecutionContext;

public class SendUserTagNotificationSummarySchedulable
extends AbstractSendTagNotificationSummarySchedulable {
    protected FrequencyHelper.Frequency _frequency;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this._frequency = FrequencyHelper.Frequency.valueOf(configuration.getChild("frequency").getValue("DAILY"));
    }

    @Override
    protected List<Site> getSiteToNotify(JobExecutionContext context) {
        return this._siteManager.getSites().stream().toList();
    }

    @Override
    protected FrequencyHelper.Frequency getFrequency(JobExecutionContext context) {
        return this._frequency;
    }

    @Override
    protected SubscriptionType.FrequencyTiming getFrequencyTiming(JobExecutionContext context) {
        return new SubscriptionType.FrequencyTiming(FrequencyHelper.getDefaultFrequencyDay(), FrequencyHelper.getDefaultFrequencyTime());
    }

    @Override
    protected Map<CMSTag, Set<UserIdentity>> getSubscribersByTag(JobExecutionContext context, Site site, FrequencyHelper.Frequency frequency) {
        HashMap<CMSTag, Set<UserIdentity>> subscribersByTag = new HashMap<CMSTag, Set<UserIdentity>>();
        Set<UserIdentity> subscribers = this._tagSubscriptionType.getSubscribers(site, frequency, BroadcastChannelHelper.BroadcastChannel.MAIL, null);
        for (UserIdentity subscriber : subscribers) {
            List<Subscription> userSubscriptions = this._tagSubscriptionType.getUserSubscriptions(site, frequency, BroadcastChannelHelper.BroadcastChannel.MAIL, subscriber, false, null).stream().filter(s -> !s.isForced()).toList();
            for (Subscription subscription : userSubscriptions) {
                CMSTag tag = this._tagSubscriptionType.getTarget(subscription);
                Set users = subscribersByTag.getOrDefault(tag, new HashSet());
                users.add(subscriber);
                subscribersByTag.put(tag, users);
            }
        }
        return subscribersByTag;
    }
}

