/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.notification;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.plugins.core.ui.user.ProfileImageResolverHelper;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.context.PageSubscriptionContext;
import org.ametys.plugins.pagesubscription.type.PageSubscriptionType;
import org.ametys.plugins.pagesubscription.type.SubscriptionType;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityHelper;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.repository.activities.ActivityTypeExtensionPoint;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.activities.PageResourcesUpdatedActivityType;
import org.ametys.web.activities.PageUpdatedActivityType;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class PageNotificationsHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = PageNotificationsHelper.class.getName();
    protected AmetysObjectResolver _resolver;
    protected SiteManager _siteManager;
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;
    protected CurrentUserProvider _currentUserProvider;
    protected UserHelper _userHelper;
    protected AbstractCacheManager _cacheManager;
    protected ActivityTypeExtensionPoint _activityTypeEP;

    public void service(ServiceManager smanager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)smanager.lookup(SubscriptionTypeExtensionPoint.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
        this._cacheManager = (AbstractCacheManager)smanager.lookup(AbstractCacheManager.ROLE);
        this._activityTypeEP = (ActivityTypeExtensionPoint)smanager.lookup(ActivityTypeExtensionPoint.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createMemoryCache(ROLE, new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_PAGE_CACHE"), new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_PAGE_CACHE_DESCRIPTION"), true, null);
    }

    @Callable(rights={"*"})
    public List<Map<String, Object>> getUnreadPages(String siteName) {
        ArrayList<Map<String, Object>> unreadPages = new ArrayList<Map<String, Object>>();
        Site site = this._siteManager.getSite(siteName);
        UserIdentity user = this._currentUserProvider.getUser();
        PageSubscriptionType pageSubscriptionType = (PageSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.page");
        List<Subscription> subscriptions = pageSubscriptionType.getUserSubscriptions(site, null, BroadcastChannelHelper.BroadcastChannel.SITE, user, false, null);
        for (Subscription subscription : subscriptions) {
            String pageId = (String)subscription.getValue("page");
            Activity lastPageActivity = this.getLastActivity(siteName, pageId, FrequencyHelper.Frequency.INSTANT);
            if (lastPageActivity == null) continue;
            ZonedDateTime lastPageActivityDate = lastPageActivity.getDate();
            ZonedDateTime lastReadDate = pageSubscriptionType.getLastReadDate(subscription, user);
            boolean hasRead = lastReadDate != null && lastReadDate.isAfter(lastPageActivityDate);
            if (hasRead) continue;
            UserIdentity author = lastPageActivity.getAuthor();
            Map author2json = this._userHelper.user2json(author);
            author2json.put("imgUrl", ProfileImageResolverHelper.resolve((String)author.getLogin(), (String)author.getPopulationId(), (int)64, null));
            unreadPages.add(Map.of("id", subscription.getId(), "pageId", pageId, "lastActivityDate", lastPageActivityDate, "author", author2json));
        }
        return unreadPages;
    }

    public Activity getLastActivity(String siteName, String pageId, FrequencyHelper.Frequency frequency) {
        SubscriptionType.FrequencyTiming timing = new SubscriptionType.FrequencyTiming(FrequencyHelper.getDefaultFrequencyDay(), FrequencyHelper.getDefaultFrequencyTime());
        ZonedDateTime notificationDate = FrequencyHelper.getNotificationDate(frequency, timing);
        PageSubscriptionKey key = PageSubscriptionKey.of(siteName, pageId, frequency, notificationDate);
        return Optional.ofNullable((String)this._getCache().get((Object)key, k -> this._getLastActivity(siteName, pageId, frequency, notificationDate))).map(this::_resolveSilently).orElse(null);
    }

    private String _getLastActivity(String siteName, String pageId, FrequencyHelper.Frequency frequency, ZonedDateTime notificationDate) {
        return this._getPageActivities(siteName, pageId, frequency, notificationDate).stream().max((a1, a2) -> a1.getDate().compareTo(a2.getDate())).map(SimpleAmetysObject::getId).orElse(null);
    }

    private AmetysObjectIterable<Activity> _getPageActivities(String siteName, String pageId, FrequencyHelper.Frequency frequency, ZonedDateTime notificationDate) {
        ArrayList<Object> finalExprs = new ArrayList<Object>();
        finalExprs.addAll(FrequencyHelper.getDateExpressions(frequency, notificationDate));
        Expression[] activityTypeExpressions = (Expression[])this._activityTypeEP.getExtensionsIds().stream().map(arg_0 -> ((ActivityTypeExtensionPoint)this._activityTypeEP).getExtension(arg_0)).filter(this::_filterActivity).map(type -> new StringExpression("activityTypeId", Expression.Operator.EQ, type.getId())).toArray(Expression[]::new);
        finalExprs.add(new OrExpression(activityTypeExpressions));
        finalExprs.add(new StringExpression("pageId", Expression.Operator.EQ, pageId));
        finalExprs.add(new StringExpression("siteName", Expression.Operator.EQ, siteName));
        AndExpression finalExpr = new AndExpression(finalExprs.toArray(new Expression[finalExprs.size()]));
        String xpathQuery = ActivityHelper.getActivityXPathQuery((Expression)finalExpr);
        return this._resolver.query(xpathQuery);
    }

    private boolean _filterActivity(ActivityType type) {
        return type instanceof PageUpdatedActivityType || type instanceof PageResourcesUpdatedActivityType;
    }

    private Activity _resolveSilently(String activityId) {
        try {
            return (Activity)this._resolver.resolveById(activityId);
        }
        catch (Exception e) {
            this.getLogger().warn("Can't resolve activity with id '{}'", (Object)activityId, (Object)e);
            return null;
        }
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.pageaccess")
    public void markPageAsRead(String pageId) {
        PageSubscriptionType pageSubscriptionType = (PageSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.page");
        Page page = (Page)this._resolver.resolveById(pageId);
        UserIdentity user = this._currentUserProvider.getUser();
        PageSubscriptionContext context = PageSubscriptionContext.newInstance().withPage(page);
        List<Subscription> subscriptions = pageSubscriptionType.getUserSubscriptions(page.getSite(), null, BroadcastChannelHelper.BroadcastChannel.SITE, user, false, context);
        for (Subscription subscription : subscriptions) {
            pageSubscriptionType.markAsRead(subscription, user);
        }
    }

    private Cache<PageSubscriptionKey, String> _getCache() {
        return this._cacheManager.get(ROLE);
    }

    public void clearCache(String siteName, String pageId) {
        this._getCache().invalidate((Object)PageSubscriptionKey.of(siteName, pageId));
    }

    static class PageSubscriptionKey
    extends AbstractCacheKey {
        PageSubscriptionKey(String siteName, String pageId, FrequencyHelper.Frequency frequency, ZonedDateTime notificationDate) {
            super(new Object[]{siteName, pageId, frequency, notificationDate});
        }

        static PageSubscriptionKey of(String siteName, String pageId, FrequencyHelper.Frequency frequency, ZonedDateTime notificationDate) {
            return new PageSubscriptionKey(siteName, pageId, frequency, notificationDate);
        }

        static PageSubscriptionKey of(String siteName, String pageId) {
            return new PageSubscriptionKey(siteName, pageId, null, null);
        }
    }
}

