/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.schedulable.tag;

import java.util.ArrayList;
import java.util.HashMap;
import org.ametys.cms.tag.CMSTag;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.schedule.Runnable;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.schedulable.tag.SendGroupTagNotificationSummaryRunnable;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.pagesubscription.type.TagSubscriptionType;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.quartz.JobKey;
import org.quartz.SchedulerException;

public class ForcedSubscriptionSchedulerHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = ForcedSubscriptionSchedulerHelper.class.getName();
    protected Scheduler _scheduler;
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;
    protected TagSubscriptionType _tagSubscriptionType;
    protected SiteManager _siteManager;
    protected GroupManager _groupManager;
    protected I18nUtils _i18nUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        this._scheduler = (Scheduler)smanager.lookup(Scheduler.ROLE);
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)smanager.lookup(SubscriptionTypeExtensionPoint.ROLE));
        this._tagSubscriptionType = (TagSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.tag");
        this._groupManager = (GroupManager)smanager.lookup(GroupManager.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
    }

    public void scheduleForcedSubscription(Subscription subscription) throws SchedulerException {
        String id = this._getRunnableId(subscription);
        JobKey jobKey = new JobKey(id, "runtime.job");
        if (!this._scheduler.getScheduler().checkExists(jobKey)) {
            I18nizableText label = this._getLabel(subscription);
            SendGroupTagNotificationSummaryRunnable subscriptionRunable = new SendGroupTagNotificationSummaryRunnable(subscription, id, label, label);
            this._scheduler.scheduleJob((Runnable)subscriptionRunable);
        }
    }

    private I18nizableText _getLabel(Subscription subscription) {
        CMSTag tag = this._tagSubscriptionType.getTarget(subscription);
        GroupIdentity groupIdentity = subscription.getSubscribersGroup().get();
        Group group = this._groupManager.getGroup(groupIdentity);
        HashMap<String, I18nizableText> params = new HashMap<String, I18nizableText>();
        params.put("tag", tag.getTitle());
        params.put("group", new I18nizableText(group.getLabel()));
        params.put("groupId", new I18nizableText(group.getLabel()));
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(this._i18nUtils.translate((I18nizable)tag.getTitle()));
        parameters.add(group.getLabel());
        parameters.add(GroupIdentity.groupIdentityToString((GroupIdentity)groupIdentity));
        return new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIPTION_MAIL_TAG_" + subscription.getFrequency().name() + "_NOTIFICATIONS_SCHEDULER_FORCED_GROUP_LABEL", parameters);
    }

    private String _getRunnableId(Subscription subscription) {
        return "runnable-" + subscription.getId();
    }

    public void unscheduleForcedSubscription(Subscription subscription) throws SchedulerException {
        String id = this._getRunnableId(subscription);
        JobKey jobKey = new JobKey(id, "runtime.job");
        if (this._scheduler.getScheduler().checkExists(jobKey)) {
            this._scheduler.getScheduler().deleteJob(jobKey);
        }
    }
}

