/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription;

import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class BroadcastChannelHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    protected static CurrentUserProvider _currentUserProvider;
    protected static UserManager _userManager;

    public void service(ServiceManager manager) throws ServiceException {
        _currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        _userManager = (UserManager)manager.lookup(UserManager.ROLE);
    }

    public static I18nizableText getLabel(BroadcastChannel broadcastChannel) {
        return new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_BROADCAST_CHANNEL_LABEL_" + broadcastChannel.name());
    }

    public static I18nizableText getSmartLabel(BroadcastChannel broadcastChannel) {
        HashMap<String, I18nizableText> params = new HashMap<String, I18nizableText>();
        switch (broadcastChannel.ordinal()) {
            case 0: {
                String email = BroadcastChannelHelper._getCurrentUserMail();
                params.put("mail", new I18nizableText(email));
                break;
            }
        }
        return new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_BROADCAST_CHANNEL_SMART_LABEL_" + broadcastChannel.name(), params);
    }

    private static String _getCurrentUserMail() {
        return Optional.ofNullable(_currentUserProvider.getUser()).map(arg_0 -> ((UserManager)_userManager).getUser(arg_0)).filter(Objects::nonNull).map(User::getEmail).orElse("");
    }

    public static enum BroadcastChannel {
        MAIL,
        SITE;

    }
}

