/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.dao;

import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.SubscriptionException;
import org.ametys.plugins.pagesubscription.type.SubscriptionType;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSubscriptionsDAO
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    protected AmetysObjectResolver _resolver;
    protected CurrentUserProvider _currentUserProvider;
    protected Context _context;

    public void service(ServiceManager smanager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    private void _checkSubscription(Subscription subscription) {
        UserIdentity user = this._currentUserProvider.getUser();
        boolean isSubscriber = subscription.getSubscriber().filter(u -> u.equals((Object)user)).isPresent();
        if (!isSubscriber) {
            throw new SubscriptionException("Can access to the subscription with id '" + subscription.getId() + "' because the subscriber is not the current user.", SubscriptionException.Type.NO_ACCESS);
        }
    }

    @Callable(rights={""})
    public Map<String, Object> getSubscription(String subscriptionId) {
        return this.getSubscription(subscriptionId, true);
    }

    public Map<String, Object> getSubscription(String subscriptionId, boolean checkCurrentUser) {
        try {
            Subscription subscription = (Subscription)this._resolver.resolveById(subscriptionId);
            if (checkCurrentUser) {
                this._checkSubscription(subscription);
            }
            return Map.of("success", true, "subscription", subscription.getSubscriptionType().subscriptionToJSON(subscription));
        }
        catch (Exception e) {
            this.getLogger().error("Fail to get subscription with id '{}'", (Object)subscriptionId, (Object)e);
            return Map.of("success", false);
        }
    }

    @Callable(rights={""})
    public Map<String, Object> editSubscription(String subscriptionId, String frequency, List<String> broadcastChannels) {
        return this.editSubscription(subscriptionId, frequency, null, broadcastChannels, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> editSubscription(String subscriptionId, String frequency, SubscriptionType.FrequencyTiming forcedTiming, List<String> broadcastChannels, boolean checkCurrentUser) {
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            List<BroadcastChannelHelper.BroadcastChannel> subChannels;
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            Subscription subscription = (Subscription)this._resolver.resolveById(subscriptionId);
            if (checkCurrentUser) {
                this._checkSubscription(subscription);
            }
            SubscriptionType subscriptionType = subscription.getSubscriptionType();
            FrequencyHelper.Frequency subFrequency = StringUtils.isNotBlank((CharSequence)frequency) ? FrequencyHelper.Frequency.valueOf(frequency) : subscription.getFrequency();
            List<BroadcastChannelHelper.BroadcastChannel> list = subChannels = broadcastChannels != null ? broadcastChannels.stream().map(BroadcastChannelHelper.BroadcastChannel::valueOf).toList() : subscription.getBroadcastChannels();
            if (forcedTiming != null) {
                subscriptionType.editForceSubscription(subscription, subFrequency, subChannels, forcedTiming, null);
            } else {
                subscriptionType.editSubscription(subscription, subFrequency, subChannels, null);
            }
            Map<String, Object> map = Map.of("success", true, "subscription", subscriptionType.subscriptionToJSON(subscription));
            return map;
        }
        catch (Exception e) {
            this.getLogger().error("Unable to edit subscription with id '{}'", (Object)subscriptionId, (Object)e);
            Map<String, Object> map = Map.of("success", false);
            return map;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }

    @Callable(rights={""})
    public boolean unsubscribe(String subscriptionId) throws Exception {
        return this.unsubscribe(subscriptionId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsubscribe(String subscriptionId, boolean checkCurrentUser) throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            Subscription subscription = (Subscription)this._resolver.resolveById(subscriptionId);
            if (checkCurrentUser) {
                this._checkSubscription(subscription);
            }
            subscription.getSubscriptionType().unsubscribe(subscription);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.getLogger().error("Fail to unsubscribe to suscription with id {}", (Object)subscriptionId, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }
}

