/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.pagesubscription.context;

import java.util.HashMap;
import java.util.Map;

import org.ametys.plugins.pagesubscription.type.SubscriptionType;

/**
 * Class to represent a context for {@link SubscriptionType}
 */
public class SubscriptionContext
{
    /** The map of parameters */
    protected Map<String, Object> _contextParameters;
    
    /**
     * Creates a new instance of a {@link SubscriptionContext}
     */
    protected SubscriptionContext()
    {
        _contextParameters = new HashMap<>();
    }
    
    /**
     * Creates a new instance of a {@link SubscriptionContext}
     * @return the created instance
     */
    public static SubscriptionContext newInstance()
    {
        return new SubscriptionContext();
    }
    
    /**
     * Add a parameter to the context
     * @param <T> the {@link SubscriptionContext}
     * @param key the parameter key
     * @param value the parameter value
     * @return the context
     */
    @SuppressWarnings("unchecked")
    public <T extends SubscriptionContext> T addParameter(String key, Object value)
    {
        _contextParameters.put(key, value);
        return (T) this;
    }
    
    /**
     * Add parameters to the context
     * @param <T> the {@link SubscriptionContext}
     * @param parameters the parameters
     * @return the context
     */
    @SuppressWarnings("unchecked")
    public <T extends SubscriptionContext> T addParameters(Map<String, Object> parameters)
    {
        _contextParameters.putAll(parameters);
        return (T) this;
    }
    
    /**
     * Get the parameter value
     * @param key the parameter key
     * @return the parameter value
     */
    public Object getParameterValue(String key)
    {
        return _contextParameters.get(key);
    }
}
