/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.tag.CMSTag;
import org.ametys.cms.tag.TagProviderExtensionPoint;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.context.TagSubscriptionContext;
import org.ametys.plugins.pagesubscription.dao.AbstractSubscriptionsDAO;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.pagesubscription.type.TagSubscriptionType;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class TagSubscriptionsDAO
extends AbstractSubscriptionsDAO {
    public static final String ROLE = TagSubscriptionsDAO.class.getName();
    protected SiteManager _siteManager;
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;
    protected TagProviderExtensionPoint _tagProviderEP;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)smanager.lookup(SubscriptionTypeExtensionPoint.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._tagProviderEP = (TagProviderExtensionPoint)smanager.lookup(TagProviderExtensionPoint.ROLE);
    }

    @Callable(rights={"*"})
    public Map<String, Object> getTagSubscriptions(String siteName, String rootTagName) {
        List<Subscription> userSubscriptions = this._getTagSubscriptions(siteName, rootTagName);
        List<Map> userSubscriptions2Json = userSubscriptions.stream().map(s -> s.getSubscriptionType().subscriptionToJSON((Subscription)((Object)s))).toList();
        boolean hasAvailableTags = !this.getAvailableTags(userSubscriptions, siteName, rootTagName).isEmpty();
        return Map.of("tagSubscriptions", userSubscriptions2Json, "hasAvailableTags", hasAvailableTags);
    }

    private List<Subscription> _getTagSubscriptions(String siteName, String rootTagName) {
        TagSubscriptionType subscriptionType = (TagSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.tag");
        Site site = this._siteManager.getSite(siteName);
        return subscriptionType.getUserSubscriptions(site, this._currentUserProvider.getUser(), false, TagSubscriptionContext.newInstance().withRootTag(rootTagName).withSiteName(siteName));
    }

    @Callable(rights={"*"})
    public List<Map<String, Object>> getAvailableTags(String siteName, String rootTagName) {
        List<Subscription> subscriptions = this._getTagSubscriptions(siteName, rootTagName);
        return this.getAvailableTags(subscriptions, siteName, rootTagName).stream().map(t -> Map.of("label", t.getTitle(), "name", t.getName())).toList();
    }

    public Set<CMSTag> getAvailableTags(List<Subscription> subscriptions, String siteName, String rootTagName) {
        List<String> tagNames = subscriptions.stream().map(s -> (String)s.getValue("tag")).toList();
        return this.getAllTags(rootTagName, siteName).stream().filter(t -> !tagNames.contains(t.getName())).collect(Collectors.toSet());
    }

    public List<CMSTag> getAllTags(String rootTagName, String siteName) {
        CMSTag tag = (CMSTag)this._tagProviderEP.getTag(rootTagName, Map.of("siteName", siteName));
        return Optional.ofNullable(tag).map(CMSTag::getTags).map(this::_getTags).orElseGet(() -> List.of());
    }

    private List<CMSTag> _getTags(Map<String, CMSTag> tags) {
        ArrayList<CMSTag> allTags = new ArrayList<CMSTag>();
        for (CMSTag childTag : tags.values()) {
            Map children = childTag.getTags();
            if (children.isEmpty()) {
                allTags.add(childTag);
                continue;
            }
            allTags.addAll(this._getTags(children));
        }
        return allTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable(rights={"*"})
    public Map<String, Object> addTagSubscription(String siteName, String rootTagName, String tag, String frequency, List<String> broadcastChannels) throws Exception {
        List<Map<String, Object>> fieldsInError = this._getFieldsInError(tag, frequency, broadcastChannels);
        if (!fieldsInError.isEmpty()) {
            return Map.of("success", false, "fieldsInError", fieldsInError);
        }
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            Site site = this._siteManager.getSite(siteName);
            TagSubscriptionType tagSubscriptionType = (TagSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.tag");
            UserIdentity user = this._currentUserProvider.getUser();
            TagSubscriptionContext context = TagSubscriptionContext.newInstance().withTag(tag);
            List<BroadcastChannelHelper.BroadcastChannel> broadcastChannelsAsEnum = broadcastChannels.stream().map(c -> BroadcastChannelHelper.BroadcastChannel.valueOf(c)).toList();
            Subscription subscription = tagSubscriptionType.subscribe(site, user, FrequencyHelper.Frequency.valueOf(frequency), broadcastChannelsAsEnum, context);
            Map<String, Object> map = Map.of("success", true, "subscription", tagSubscriptionType.subscriptionToJSON(subscription), "hasAvailableTags", !this.getAvailableTags(siteName, rootTagName).isEmpty());
            return map;
        }
        catch (Exception e) {
            this.getLogger().error("Unable to add tag subscription for site name '{}' and tag '{}'", new Object[]{siteName, tag, e});
            Map<String, Object> map = Map.of("success", false);
            return map;
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }

    private List<Map<String, Object>> _getFieldsInError(String tag, String frequency, List<String> broadcastChannels) {
        ArrayList<Map<String, Object>> fieldsInError = new ArrayList<Map<String, Object>>();
        if (StringUtils.isBlank((CharSequence)tag)) {
            fieldsInError.add(Map.of("fieldName", "tag", "error", new I18nizableText("plugin.page-subscription", "TAG_SUBSCRIPTION_HELPER_FORM_TAG_MANDATORY_ERROR")));
        }
        if (StringUtils.isBlank((CharSequence)frequency)) {
            fieldsInError.add(Map.of("fieldName", "frequency", "error", new I18nizableText("plugin.page-subscription", "TAG_SUBSCRIPTION_HELPER_FORM_FREQUENCY_MANDATORY_ERROR")));
        }
        if (broadcastChannels == null || broadcastChannels.isEmpty()) {
            fieldsInError.add(Map.of("fieldName", "broadcastChannel", "error", new I18nizableText("plugin.page-subscription", "TAG_SUBSCRIPTION_HELPER_FORM_CHANNEL_MANDATORY_ERROR")));
        }
        return fieldsInError;
    }
}

