/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.type;

import java.util.Map;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.plugins.pagesubscription.BroadcastChannelHelper;
import org.ametys.plugins.pagesubscription.FrequencyHelper;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.context.PageSubscriptionContext;
import org.ametys.plugins.pagesubscription.type.AbstractSubscriptionType;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.Page;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PageSubscriptionType
extends AbstractSubscriptionType<PageSubscriptionContext, String> {
    public static final String ID = "subscription.page";
    public static final String PAGE = "page";
    public static final String SITEMAP = "sitemap";

    @Override
    public String getTarget(Subscription subscription) {
        return (String)subscription.getValue(PAGE);
    }

    @Override
    protected void setAdditionalData(Subscription subscription, PageSubscriptionContext context) {
        Page page = context.getPage();
        subscription.setValue(PAGE, page.getId());
        subscription.setValue(SITEMAP, page.getSitemapName());
    }

    @Override
    protected boolean isSubscriptionValid(Subscription subscription) {
        String pageId = (String)subscription.getValue(PAGE);
        return StringUtils.isNotBlank((CharSequence)pageId) ? this._resolver.hasAmetysObjectForId(pageId) : false;
    }

    @Override
    protected Expression getAdditionalFilterExpression(PageSubscriptionContext context) {
        Page page = context.getPage();
        if (page != null) {
            return new StringExpression(PAGE, Expression.Operator.EQ, page.getId());
        }
        return null;
    }

    @Override
    public Map<String, Object> subscriptionToJSON(Subscription subscription) {
        Map<String, Object> subscriptionToJSON = super.subscriptionToJSON(subscription);
        String pageId = (String)subscription.getValue(PAGE);
        try {
            Page page = (Page)this._resolver.resolveById(pageId);
            subscriptionToJSON.put(PAGE, Map.of("label", page.getTitle(), "id", page.getId(), "url", ResolveURIComponent.resolve((String)PAGE, (String)pageId, (boolean)false)));
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred getting page for id '{}'", (Object)pageId, (Object)e);
        }
        return subscriptionToJSON;
    }

    @Override
    protected Map<String, Object> _frequencyToJson(Subscription subscription) {
        Map<String, Object> frequency2json = super._frequencyToJson(subscription);
        frequency2json.put("label", this._getPageSubscriptionFrequencyLabel(subscription));
        frequency2json.put("smartLabel", this._getPageSubscriptionFrequencySmartLabel(subscription));
        return frequency2json;
    }

    @Override
    protected void _saxAdditionalData(ContentHandler contentHandler, Subscription subscription) throws SAXException {
        super._saxAdditionalData(contentHandler, subscription);
        String pageId = (String)subscription.getValue(PAGE);
        try {
            Page page = (Page)this._resolver.resolveById(pageId);
            AttributesImpl attrsPage = new AttributesImpl();
            attrsPage.addCDATAAttribute("id", pageId);
            XMLUtils.createElement((ContentHandler)contentHandler, (String)PAGE, (Attributes)attrsPage, (String)page.getTitle());
        }
        catch (UnknownAmetysObjectException e) {
            this.getLogger().error("Unknown page for id '{}'", (Object)pageId, (Object)e);
        }
    }

    @Override
    protected void _saxFrequency(ContentHandler contentHandler, Subscription subscription) throws SAXException {
        FrequencyHelper.Frequency frequency = subscription.getFrequency();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("name", frequency.name());
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"frequency", (Attributes)attrs);
        this._getPageSubscriptionFrequencyLabel(subscription).toSAX(contentHandler, "label");
        this._getPageSubscriptionFrequencySmartLabel(subscription).toSAX(contentHandler, "smartLabel");
        FrequencyHelper.getFullLabel(frequency, subscription.getBroadcastChannels());
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"frequency");
    }

    private I18nizableText _getPageSubscriptionFrequencyLabel(Subscription pageSubscription) {
        return pageSubscription.getBroadcastChannels().contains((Object)BroadcastChannelHelper.BroadcastChannel.MAIL) ? FrequencyHelper.getLabel(pageSubscription.getFrequency()) : new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_FREQUENCY_NO_MAIL");
    }

    private I18nizableText _getPageSubscriptionFrequencySmartLabel(Subscription pageSubscription) {
        return pageSubscription.getBroadcastChannels().contains((Object)BroadcastChannelHelper.BroadcastChannel.MAIL) ? FrequencyHelper.getSmartLabel(pageSubscription.getFrequency()) : new I18nizableText("plugin.page-subscription", "PLUGINS_PAGE_SUBSCRIBE_USER_SUBSCRIPTIONS_FREQUENCY_NO_MAIL");
    }

    @Override
    protected String getUserPreferenceContextId(Subscription subscription) {
        return this.getTarget(subscription);
    }
}

