/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription;

import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Map;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.user.status.PersonalDataPolicy;
import org.ametys.core.user.status.UserStatusInfo;
import org.ametys.plugins.pagesubscription.type.SubscriptionType;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class SubscriptionDataPolicy
extends AbstractLogEnabled
implements PersonalDataPolicy,
Serviceable {
    protected SiteManager _siteManager;
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;
    private Period _retentionPeriod;

    public void service(ServiceManager manager) throws ServiceException {
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)manager.lookup(SubscriptionTypeExtensionPoint.ROLE));
        Long config = (Long)Config.getInstance().getValue("page-subscription.retention", false, null);
        this._retentionPeriod = config != null && config >= 0L ? Period.ofMonths(config.intValue()) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PersonalDataPolicy.AnonymizationResult process(UserStatusInfo userStatusInfo) {
        if (this._retentionPeriod == null) {
            return PersonalDataPolicy.AnonymizationResult.TOO_EARLY;
        }
        if (!userStatusInfo.getMissingSinceDate().isBefore(ZonedDateTime.now().minus(this._retentionPeriod))) return PersonalDataPolicy.AnonymizationResult.TOO_EARLY;
        UserIdentity userIdentity = userStatusInfo.getUserIdentity();
        try (AmetysObjectIterable sites = this._siteManager.getSites();){
            AmetysObjectIterator ametysObjectIterator;
            long deletedSubscriptions = 0L;
            for (Site site : sites) {
                for (String typeId : this._subscriptionTypeEP.getExtensionsIds()) {
                    SubscriptionType subscriptionType = (SubscriptionType)this._subscriptionTypeEP.getExtension(typeId);
                    deletedSubscriptions += subscriptionType.unsubscribeAll(site, userIdentity);
                }
            }
            if (deletedSubscriptions > 0L) {
                ForensicLogger.info((String)"data.policy.gdpr.remove.page.subscriptions", Map.of("handled", Long.toString(deletedSubscriptions), "identity", userIdentity), (UserIdentity)UserPopulationDAO.SYSTEM_USER_IDENTITY);
                ametysObjectIterator = PersonalDataPolicy.AnonymizationResult.PROCESSED;
                return ametysObjectIterator;
            }
            ametysObjectIterator = PersonalDataPolicy.AnonymizationResult.NO_DATA;
            return ametysObjectIterator;
        }
        catch (Exception e) {
            this.getLogger().error("An error prevented to remove all the subscription of the unknown user '" + String.valueOf(userIdentity), (Throwable)e);
            return PersonalDataPolicy.AnonymizationResult.ERROR;
        }
    }
}

