/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.pagesubscription.type;

import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.ametys.runtime.plugin.component.LazyInitializeExtensions;

/**
 * This class is in charge of loading the various {@link SubscriptionType}.
 */
@LazyInitializeExtensions
public class SubscriptionTypeExtensionPoint extends AbstractThreadSafeComponentExtensionPoint<SubscriptionType>
{
    /** The Avalon Role */
    public static final String ROLE = SubscriptionTypeExtensionPoint.class.getName();
}
