/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.pagesubscription.tracking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ametys.cms.tag.CMSTag;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.pagesubscription.Subscription;
import org.ametys.plugins.pagesubscription.type.SubscriptionTypeExtensionPoint;
import org.ametys.plugins.pagesubscription.type.TagSubscriptionType;
import org.ametys.plugins.webanalytics.matomo.tracking.AbstractMatomoEventTrackingProvider;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class TagSubscriptionMatomoTrackingProvider
extends AbstractMatomoEventTrackingProvider
implements Serviceable {
    protected SubscriptionTypeExtensionPoint _subscriptionTypeEP;
    protected GroupManager _groupManager;
    protected I18nUtils _i18nUtils;

    public void service(ServiceManager manager) throws ServiceException {
        this._subscriptionTypeEP = (SubscriptionTypeExtensionPoint)((Object)manager.lookup(SubscriptionTypeExtensionPoint.ROLE));
        this._groupManager = (GroupManager)manager.lookup(GroupManager.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
    }

    protected List<AbstractMatomoEventTrackingProvider.MatomoEvent> getEvents(Site site) {
        ArrayList<AbstractMatomoEventTrackingProvider.MatomoEvent> requests = new ArrayList<AbstractMatomoEventTrackingProvider.MatomoEvent>();
        for (Map.Entry<CMSTag, Set<UserIdentity>> entry : this._getSubscribers(site).entrySet()) {
            CMSTag tag = entry.getKey();
            requests.add(new AbstractMatomoEventTrackingProvider.MatomoEvent(this._i18nUtils.translate((I18nizable)tag.getTitle()), (double)entry.getValue().size()));
        }
        return requests;
    }

    private Map<CMSTag, Set<UserIdentity>> _getSubscribers(Site site) {
        TagSubscriptionType subscriptionType = (TagSubscriptionType)this._subscriptionTypeEP.getExtension("subscription.tag");
        HashMap<CMSTag, Set<UserIdentity>> subscribers = new HashMap<CMSTag, Set<UserIdentity>>();
        for (Subscription subscription : subscriptionType.getSubscriptions(site, null, null, null)) {
            CMSTag tag = subscriptionType.getTarget(subscription);
            Set users = subscribers.computeIfAbsent(tag, __ -> new HashSet());
            subscription.getSubscriber().ifPresent(users::add);
            subscription.getSubscribersGroup().map(arg_0 -> ((GroupManager)this._groupManager).getGroup(arg_0)).filter(Objects::nonNull).map(Group::getUsers).ifPresent(users::addAll);
        }
        return subscribers;
    }
}

